/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.tls.SSLHandlerFactory;
import org.dcache.xrootd.tpc.XrootdTpcInfo;
import org.dcache.xrootd.util.ServerProtocolFlags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSSessionInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(TLSSessionInfo.class);
    private final ServerTlsSession serverSession;
    private ClientTlsSession tpcClientSession;
    private SSLHandlerFactory serverSslHandlerFactory;
    private SSLHandlerFactory clientSslHandlerFactory;

    public static boolean isTLSOn(ChannelHandlerContext ctx) {
        return ctx.pipeline().get(SslHandler.class) != null;
    }

    private static void operationComplete(String origin, Future<Channel> future) {
        if (future.isSuccess()) {
            LOGGER.debug("{}: TLS handshake completed.", (Object)origin);
        } else {
            LOGGER.warn("{}: TLS handshake failed: {}.", (Object)origin, (Object)String.valueOf(future.cause()));
        }
    }

    public TLSSessionInfo(ServerProtocolFlags serverFlags) {
        this.serverSession = new ServerTlsSession(serverFlags);
    }

    public TLSSessionInfo(TLSSessionInfo other) {
        this.serverSession = new ServerTlsSession(other.serverSession);
        this.clientSslHandlerFactory = other.clientSslHandlerFactory;
        this.serverSslHandlerFactory = other.serverSslHandlerFactory;
    }

    public boolean clientTransitionedToTLS(int request, ChannelHandlerContext ctx) throws XrootdException {
        boolean response = this.tpcClientSession.transitionedToTLS(request, ctx);
        LOGGER.debug("client transitioned to TLS ? {}.", (Object)response);
        return response;
    }

    public boolean clientUsesTls() {
        ClientTls clientTls = ClientTls.getMode(this.tpcClientSession.version, this.tpcClientSession.options);
        boolean response = clientTls != ClientTls.NONE;
        LOGGER.debug("client uses TLS ? {}.", (Object)response);
        return response;
    }

    public void createClientSession(XrootdTpcInfo info) {
        this.tpcClientSession = new ClientTlsSession(info);
        this.tpcClientSession.configure();
    }

    public boolean isIncomingClientTLSCapable() {
        ClientTls clientTls = ClientTls.getMode(this.serverSession.version, this.serverSession.options);
        boolean response = clientTls != ClientTls.NONE;
        LOGGER.debug("isClientTLSCapable ? {}.", (Object)response);
        return response;
    }

    public void setSourceServerFlags(int sourceServerFlags) {
        LOGGER.debug("setSourceServerFlags {}.", (Object)sourceServerFlags);
        this.tpcClientSession.setSourceServerFlags(sourceServerFlags);
    }

    public int[] getClientFlags() {
        return new int[]{this.tpcClientSession.version, this.tpcClientSession.options, this.tpcClientSession.expect};
    }

    public String getClientTls() {
        return ClientTls.getMode(this.tpcClientSession.version, this.tpcClientSession.options).name();
    }

    public ServerProtocolFlags getLocalServerProtocolFlags() {
        return this.serverSession.serverFlags;
    }

    public boolean serverTransitionedToTLS(int request, ChannelHandlerContext ctx) throws XrootdException {
        boolean response = this.serverSession.transitionedToTLS(request, ctx);
        LOGGER.debug("server transitioned to TLS ? {}.", (Object)response);
        return response;
    }

    public boolean serverUsesTls() {
        boolean response = TlsActivation.valueOf(this.serverSession.serverFlags) != TlsActivation.NONE;
        LOGGER.debug("server uses TLS ? {}.", (Object)response);
        return response;
    }

    public void setClientSslHandlerFactory(SSLHandlerFactory sslHandlerFactory) {
        this.clientSslHandlerFactory = sslHandlerFactory;
    }

    public void setLocalTlsActivation(int version, int clientOptions, int clientExpect) throws XrootdException {
        LOGGER.debug("setLocalTlsActivation {}, {}, {}.", new Object[]{version, clientExpect, clientOptions});
        this.serverSession.setClientFlags(version, clientOptions, clientExpect);
        this.serverSession.configure();
    }

    public void setServerSslHandlerFactory(SSLHandlerFactory serverSslHandlerFactory) {
        this.serverSslHandlerFactory = serverSslHandlerFactory;
    }

    class ClientTlsSession
    extends TlsSession {
        protected final boolean requiresTLS;

        protected ClientTlsSession(XrootdTpcInfo info) {
            this.requiresTLS = info.isTls();
        }

        @Override
        protected void configure() {
            this.version = 1280;
            this.expect = 3;
            switch (((TLSSessionInfo)TLSSessionInfo.this).serverSession.serverFlags.getMode()) {
                case OFF: {
                    this.options = 1;
                    break;
                }
                default: {
                    this.options = this.requiresTLS ? 4 : 3;
                }
            }
        }

        protected void setSourceServerFlags(int flags) {
            this.serverFlags = new ServerProtocolFlags(flags);
        }

        @Override
        protected boolean transitionedToTLS(int request, ChannelHandlerContext ctx) throws XrootdException {
            if (!((TLSSessionInfo)TLSSessionInfo.this).serverSession.serverFlags.supportsTLS()) {
                return false;
            }
            if (ctx.pipeline().get(SslHandler.class) != null) {
                return false;
            }
            if (!this.serverFlags.supportsTLS()) {
                if (this.requiresTLS) {
                    throw new XrootdException(3028, "Source is not able to accept secure connections.");
                }
                return false;
            }
            if (TLSSessionInfo.this.clientSslHandlerFactory == null) {
                throw new XrootdException(3012, "no ssl handler factory set on third-party client.");
            }
            boolean activate = this.serverFlags.goToTLS();
            TlsActivation tlsActivation = TlsActivation.valueOf(this.serverFlags);
            if (!activate) {
                switch (request) {
                    case 3007: {
                        activate = tlsActivation == TlsActivation.LOGIN;
                        break;
                    }
                    case 3024: {
                        activate = tlsActivation == TlsActivation.DATA;
                        break;
                    }
                    default: {
                        boolean bl = activate = tlsActivation != TlsActivation.TPC && tlsActivation != TlsActivation.NONE;
                    }
                }
            }
            if (activate) {
                this.sslHandler = (SslHandler)TLSSessionInfo.this.clientSslHandlerFactory.createHandler();
                this.sslHandler.engine().setNeedClientAuth(false);
                this.sslHandler.engine().setWantClientAuth(false);
                ctx.pipeline().addFirst(new ChannelHandler[]{this.sslHandler});
                LOGGER.debug("PIPELINE addFirst:  SSLHandler need auth {}, want auth, {}.", (Object)this.sslHandler.engine().getNeedClientAuth(), (Object)this.sslHandler.engine().getWantClientAuth());
                this.sslHandler.handshakeFuture().addListener((GenericFutureListener)this);
                LOGGER.info("TPC client initiating SSL handshake");
            }
            return activate;
        }

        public void operationComplete(Future<Channel> future) {
            TLSSessionInfo.operationComplete("TPC client", (Future<Channel>)future);
        }
    }

    class ServerTlsSession
    extends TlsSession {
        protected ServerTlsSession(ServerProtocolFlags localServerFlags) {
            super(localServerFlags);
        }

        protected ServerTlsSession(TlsSession other) {
            super(other);
        }

        @Override
        protected void configure() throws XrootdException {
            ClientTls clientTls = ClientTls.getMode(this.version, this.options);
            if (clientTls == ClientTls.NONE) {
                LOGGER.debug("Client NOT TLS capable.");
                this.serverFlags.setMode(ServerProtocolFlags.TlsMode.OFF);
                LOGGER.debug("TLS is OFF.");
                return;
            }
            if (this.serverFlags.getMode() == ServerProtocolFlags.TlsMode.OFF) {
                LOGGER.debug("TLS is OFF.");
                if (clientTls == ClientTls.REQUIRES) {
                    throw new XrootdException(3028, "Server is not able to accept secure connections.");
                }
                return;
            }
            if (clientTls == ClientTls.REQUIRES) {
                LOGGER.debug("Client kXR_wantTLS.");
                this.serverFlags.setRequiresTLSForLogin(true);
                this.serverFlags.setGoToTLS(true);
                LOGGER.debug("setLocalTlsActivation, activation is now {}.", (Object)TlsActivation.LOGIN);
                return;
            }
            if (this.serverFlags.getMode() == ServerProtocolFlags.TlsMode.OPTIONAL) {
                this.serverFlags.setRequiresTLSForData(false);
                this.serverFlags.setRequiresTLSForSession(false);
                this.serverFlags.setRequiresTLSForGPF(false);
                this.serverFlags.setRequiresTLSForGPFA(false);
                this.serverFlags.setRequiresTLSForLogin(false);
                this.serverFlags.setRequiresTLSForSession(false);
                this.serverFlags.setRequiresTLSForTPC(false);
                LOGGER.debug("setLocalTlsActivation, server mode is OPTIONAL, flags are turned off.");
                return;
            }
            switch (this.expect) {
                case 0: {
                    LOGGER.debug("setLocalTlsActivation, no expect flags.");
                    break;
                }
                case 1: {
                    if (!this.serverFlags.requiresTLSForData()) break;
                    LOGGER.debug("setLocalTlsActivation, requires TLS for data, client kXR_ExpBind.");
                    this.serverFlags.setGoToTLS(true);
                    break;
                }
                case 2: {
                    if (!this.serverFlags.requiresTLSForLogin()) break;
                    LOGGER.debug("setLocalTlsActivation, requires TLS for login, client kXR_ExpGPF.");
                    this.serverFlags.setGoToTLS(true);
                    break;
                }
                case 32: {
                    if (!this.serverFlags.requiresTLSForGPFA()) break;
                    LOGGER.debug("setLocalTlsActivation, requires TLS for GPFA, client kXR_ExpGPFA.");
                    this.serverFlags.setGoToTLS(true);
                    break;
                }
                case 3: {
                    if (!this.serverFlags.requiresTLSForLogin()) break;
                    LOGGER.debug("setLocalTlsActivation, requires TLS for login, client kXR_ExpLogin.");
                    this.serverFlags.setGoToTLS(true);
                    break;
                }
                case 4: {
                    if (this.serverFlags.requiresTLSForLogin()) {
                        LOGGER.debug("setLocalTlsActivation, requires TLS for login, client kXR_ExpTPC.");
                        this.serverFlags.setGoToTLS(true);
                        break;
                    }
                    if (!this.serverFlags.requiresTLSForTPC()) break;
                    this.serverFlags.setRequiresTLSForSession(true);
                    LOGGER.debug("setLocalTlsActivation, requires TLS for TPC, client kXR_ExpTPC; setting TLS for session to true.");
                    break;
                }
            }
        }

        @Override
        protected boolean transitionedToTLS(int request, ChannelHandlerContext ctx) throws XrootdException {
            if (TLSSessionInfo.isTLSOn(ctx)) {
                return false;
            }
            TlsActivation tlsActivation = TlsActivation.valueOf(this.serverFlags);
            LOGGER.debug("transitionedToTLS, server tlsActivation: {}.", (Object)tlsActivation);
            if (tlsActivation == TlsActivation.NONE || tlsActivation == TlsActivation.TPC) {
                return false;
            }
            if (TLSSessionInfo.this.serverSslHandlerFactory == null) {
                throw new XrootdException(3012, "no ssl handler factory set on server.");
            }
            boolean activate = this.serverFlags.goToTLS();
            if (!activate) {
                switch (request) {
                    case 3006: {
                        activate = tlsActivation == TlsActivation.LOGIN;
                        break;
                    }
                    case 3024: {
                        activate = tlsActivation == TlsActivation.DATA;
                        break;
                    }
                    default: {
                        activate = true;
                    }
                }
            }
            if (activate) {
                this.serverFlags.setGoToTLS(true);
                this.sslHandler = (SslHandler)TLSSessionInfo.this.serverSslHandlerFactory.createHandler();
                this.sslHandler.engine().setNeedClientAuth(false);
                this.sslHandler.engine().setWantClientAuth(false);
                ctx.pipeline().addFirst(new ChannelHandler[]{this.sslHandler});
                LOGGER.debug("PIPELINE addFirst:  SSLHandler need auth {}, want auth {}.", (Object)this.sslHandler.engine().getNeedClientAuth(), (Object)this.sslHandler.engine().getWantClientAuth());
                this.sslHandler.handshakeFuture().addListener((GenericFutureListener)this);
            }
            return activate;
        }

        public void operationComplete(Future<Channel> future) {
            TLSSessionInfo.operationComplete("Server", (Future<Channel>)future);
        }
    }

    abstract class TlsSession
    implements FutureListener<Channel> {
        protected ServerProtocolFlags serverFlags;
        protected int version;
        protected int options;
        protected int expect;
        protected SslHandler sslHandler;

        protected TlsSession() {
        }

        protected TlsSession(ServerProtocolFlags serverFlags) {
            this.serverFlags = new ServerProtocolFlags(serverFlags);
        }

        protected TlsSession(TlsSession other) {
            this.serverFlags = new ServerProtocolFlags(other.serverFlags);
            this.version = other.version;
            this.options = other.options;
            this.expect = other.expect;
        }

        protected void setClientFlags(int version, int options, int expect) {
            this.version = version;
            this.options = options;
            this.expect = expect;
            LOGGER.debug("Client version {}, options {}, expect {}.", new Object[]{version, options, expect});
        }

        protected abstract void configure() throws XrootdException;

        protected abstract boolean transitionedToTLS(int var1, ChannelHandlerContext var2) throws XrootdException;
    }

    static enum TlsActivation {
        NONE,
        LOGIN,
        SESSION,
        DATA,
        GPF,
        TPC;


        public static TlsActivation valueOf(ServerProtocolFlags flags) {
            if (flags.getMode() == ServerProtocolFlags.TlsMode.OFF) {
                return NONE;
            }
            if (flags.getMode() == ServerProtocolFlags.TlsMode.STRICT) {
                return LOGIN;
            }
            if (flags.requiresTLSForLogin()) {
                return LOGIN;
            }
            if (flags.requiresTLSForData()) {
                return DATA;
            }
            if (flags.requiresTLSForGPF()) {
                return GPF;
            }
            if (flags.requiresTLSForSession()) {
                return SESSION;
            }
            if (flags.requiresTLSForTPC()) {
                return TPC;
            }
            return NONE;
        }
    }

    static enum ClientTls {
        REQUIRES,
        ABLE,
        NONE;


        static ClientTls getMode(int version, int options) {
            if (version < 1280) {
                return NONE;
            }
            if ((options & 4) == 4) {
                return REQUIRES;
            }
            if ((options & 2) == 2) {
                return ABLE;
            }
            return NONE;
        }
    }
}

