/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public interface XrootdSecurityProtocol {
    public static final String SEC_PROTOCOL_PREFIX = "P=";
    public static final String AUTHN_PROTOCOL_PREFIX = "&P=";
    public static final String ZTN = "ztn";
    public static final int kgST_ok = 0;
    public static final int kgST_error = -1;
    public static final int kgST_more = 1;
    public static final int kOptsDlgPxy = 1;
    public static final int kOptsFwdPxy = 2;
    public static final int kOptsSigReq = 4;
    public static final int kOptsSrvReq = 8;
    public static final int kOptsPxFile = 16;
    public static final int kOptsDelChn = 32;
    public static final int kXR_secver_0 = 0;
    public static final int kXR_secNone = 0;
    public static final int kXR_secCompatible = 1;
    public static final int kXR_secStandard = 2;
    public static final int kXR_secIntense = 3;
    public static final int kXR_secPedantic = 4;
    public static final byte kXR_sec0Data = 1;
    public static final byte kXR_secOFrce = 2;
    public static final int kXR_signIgnore = 0;
    public static final int kXR_signLikely = 1;
    public static final int kXR_signNeeded = 2;
    public static final byte kXR_nodata = 1;
    public static final int kXGC_none = 0;
    public static final int kXGC_certreq = 1000;
    public static final int kXGC_cert = 1001;
    public static final int kXGC_sigpxy = 1002;
    public static final int kXGC_reserved = 1003;
    public static final int kXGS_none = 0;
    public static final int kXGS_init = 2000;
    public static final int kXGS_cert = 2001;
    public static final int kXGS_pxyreq = 2002;
    public static final int kXGS_reserved = 2003;
    public static final int kGSErrParseBuffer = 10000;
    public static final int kGSErrDecodeBuffer = 10001;
    public static final int kGSErrBadProtocol = 10003;
    public static final int kGSErrCreateBucket = 10004;
    public static final int kGSErrSerialBuffer = 10007;
    public static final int kGSErrBadRndmTag = 10011;
    public static final int kGSErrNoCipher = 10013;
    public static final int kGSErrBadOpt = 10015;
    public static final int kGSErrNoBuffer = 10019;
    public static final int kGSErrNoPublic = 10021;
    public static final int kGSErrAddBucket = 10022;
    public static final int kGSErrInit = 10024;
    public static final int kGSErrError = 10026;

    public static String getClientStep(int step) {
        switch (step) {
            case 0: {
                return "kXGC_none";
            }
            case 1000: {
                return "kXGC_certreq";
            }
            case 1001: {
                return "kXGC_cert";
            }
            case 1002: {
                return "kXGC_sigpxy";
            }
            case 1003: {
                return "kXGC_reserved";
            }
        }
        return "unrecognized step: " + step;
    }

    public static String getServerStep(int step) {
        switch (step) {
            case 0: {
                return "kXGS_none";
            }
            case 2000: {
                return "kXGS_init";
            }
            case 2001: {
                return "kXGS_cert";
            }
            case 2002: {
                return "kXGS_pxyreq";
            }
            case 2003: {
                return "kXGS_reserved";
            }
        }
        return "unrecognized step: " + step;
    }

    public static enum BucketType {
        kXRS_none(0),
        kXRS_inactive(1),
        kXRS_cryptomod(3000),
        kXRS_main(3001),
        kXRS_srv_seal(3002),
        kXRS_clnt_seal(3003),
        kXRS_puk(3004),
        kXRS_cipher(3005),
        kXRS_rtag(3006),
        kXRS_signed_rtag(3007),
        kXRS_user(3008),
        kXRS_host(3009),
        kXRS_creds(3010),
        kXRS_message(3011),
        kXRS_srvID(3012),
        kXRS_sessionID(3013),
        kXRS_version(3014),
        kXRS_status(3015),
        kXRS_localstatus(3016),
        kXRS_othercreds(3017),
        kXRS_cache_idx(3018),
        kXRS_clnt_opts(3019),
        kXRS_error_code(3020),
        kXRS_timestamp(3021),
        kXRS_x509(3022),
        kXRS_issuer_hash(3023),
        kXRS_x509_req(3024),
        kXRS_cipher_alg(3025),
        kXRS_md_alg(3026),
        kXRS_afsinfo(3027),
        kXRS_reserved(3028);

        private static final Map<Integer, BucketType> LOOKUP;
        private final int code;

        private BucketType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static BucketType get(int code) {
            return LOOKUP.get(code);
        }

        static {
            LOOKUP = new HashMap<Integer, BucketType>();
            for (BucketType s : EnumSet.allOf(BucketType.class)) {
                LOOKUP.put(s.getCode(), s);
            }
        }
    }
}

