/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;
import org.dcache.xrootd.util.FileStatus;

public class InboundOpenReadOnlyResponse
extends AbstractXrootdInboundResponse {
    private final int resplen;
    private final int fhandle;
    private final int cpsize;
    private final int cptype;
    private final FileStatus fileStatus;

    public InboundOpenReadOnlyResponse(ByteBuf buffer) {
        super(buffer);
        this.resplen = buffer.getInt(4);
        this.fhandle = buffer.getInt(8);
        this.cpsize = buffer.getInt(12);
        this.cptype = buffer.getInt(16);
        int len = this.resplen - 12;
        this.fileStatus = this.resplen > 0 ? new FileStatus(buffer.toString(20, len, StandardCharsets.US_ASCII)) : null;
    }

    public int getCpsize() {
        return this.cpsize;
    }

    public int getCptype() {
        return this.cptype;
    }

    public int getFhandle() {
        return this.fhandle;
    }

    public FileStatus getFileStatus() {
        return this.fileStatus;
    }

    @Override
    public int getRequestId() {
        return 3010;
    }
}

