/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.core.XrootdRequestHandler;
import org.dcache.xrootd.plugins.AuthorizationFactory;
import org.dcache.xrootd.plugins.AuthorizationHandler;
import org.dcache.xrootd.protocol.XrootdProtocol;
import org.dcache.xrootd.protocol.messages.CloseRequest;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.LocateRequest;
import org.dcache.xrootd.protocol.messages.MkDirRequest;
import org.dcache.xrootd.protocol.messages.MvRequest;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.protocol.messages.PathRequest;
import org.dcache.xrootd.protocol.messages.PrepareRequest;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.protocol.messages.QueryRequest;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.protocol.messages.RmDirRequest;
import org.dcache.xrootd.protocol.messages.RmRequest;
import org.dcache.xrootd.protocol.messages.SetRequest;
import org.dcache.xrootd.protocol.messages.StatRequest;
import org.dcache.xrootd.protocol.messages.StatxRequest;
import org.dcache.xrootd.protocol.messages.SyncRequest;
import org.dcache.xrootd.protocol.messages.WriteRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.util.OpaqueStringParser;
import org.dcache.xrootd.util.ParseException;

@ChannelHandler.Sharable
public class XrootdAuthorizationHandler
extends XrootdRequestHandler {
    private final AuthorizationFactory _authorizationFactory;

    public XrootdAuthorizationHandler(AuthorizationFactory authorizationFactory) {
        this._authorizationFactory = authorizationFactory;
    }

    @Override
    protected Void doOnStat(ChannelHandlerContext ctx, StatRequest req) throws XrootdException {
        switch (req.getTarget()) {
            case PATH: {
                this.authorize(ctx, req, XrootdProtocol.FilePerm.READ);
            }
        }
        ctx.fireChannelRead((Object)req);
        return null;
    }

    @Override
    protected Void doOnStatx(ChannelHandlerContext ctx, StatxRequest req) throws XrootdException {
        if (req.getPaths().length == 0) {
            throw new XrootdException(3001, "no paths specified");
        }
        String[] paths = req.getPaths();
        String[] opaques = req.getOpaques();
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = this.authorize(ctx, req, XrootdProtocol.FilePerm.READ, paths[i], opaques[i]);
        }
        req.setPaths(paths);
        ctx.fireChannelRead((Object)req);
        return null;
    }

    @Override
    protected Void doOnRm(ChannelHandlerContext ctx, RmRequest req) throws XrootdException {
        if (req.getPath().isEmpty()) {
            throw new XrootdException(3001, "no path specified");
        }
        this.authorize(ctx, req, XrootdProtocol.FilePerm.DELETE);
        ctx.fireChannelRead((Object)req);
        return null;
    }

    @Override
    protected Void doOnRmDir(ChannelHandlerContext ctx, RmDirRequest req) throws XrootdException {
        if (req.getPath().isEmpty()) {
            throw new XrootdException(3001, "no path specified");
        }
        this.authorize(ctx, req, XrootdProtocol.FilePerm.DELETE);
        ctx.fireChannelRead((Object)req);
        return null;
    }

    @Override
    protected Void doOnMkDir(ChannelHandlerContext ctx, MkDirRequest req) throws XrootdException {
        if (req.getPath().isEmpty()) {
            throw new XrootdException(3001, "no path specified");
        }
        this.authorize(ctx, req, XrootdProtocol.FilePerm.WRITE);
        ctx.fireChannelRead((Object)req);
        return null;
    }

    @Override
    protected Void doOnMv(ChannelHandlerContext ctx, MvRequest req) throws XrootdException {
        String sourcePath = req.getSourcePath();
        if (sourcePath.isEmpty()) {
            throw new XrootdException(3001, "No source path specified");
        }
        String targetPath = req.getTargetPath();
        if (targetPath.isEmpty()) {
            throw new XrootdException(3001, "No target path specified");
        }
        req.setSourcePath(this.authorize(ctx, req, XrootdProtocol.FilePerm.DELETE, req.getSourcePath(), req.getSourceOpaque()));
        req.setTargetPath(this.authorize(ctx, req, XrootdProtocol.FilePerm.WRITE, req.getTargetPath(), req.getTargetOpaque()));
        ctx.fireChannelRead((Object)req);
        return null;
    }

    @Override
    protected Void doOnDirList(ChannelHandlerContext ctx, DirListRequest request) throws XrootdException {
        String path = request.getPath();
        if (path.isEmpty()) {
            throw new XrootdException(3001, "no source path specified");
        }
        this.authorize(ctx, request, XrootdProtocol.FilePerm.READ);
        ctx.fireChannelRead((Object)request);
        return null;
    }

    @Override
    protected Void doOnPrepare(ChannelHandlerContext ctx, PrepareRequest msg) {
        ctx.fireChannelRead((Object)msg);
        return null;
    }

    @Override
    protected Void doOnLocate(ChannelHandlerContext ctx, LocateRequest msg) throws XrootdException {
        String path = msg.getPath();
        if (!path.startsWith("*")) {
            path = this.authorize(ctx, msg, XrootdProtocol.FilePerm.READ, path, msg.getOpaque());
        } else if (!path.equals("*")) {
            path = this.authorize(ctx, msg, XrootdProtocol.FilePerm.READ, path.substring(1), msg.getOpaque());
        }
        msg.setPath(path);
        ctx.fireChannelRead((Object)msg);
        return null;
    }

    @Override
    protected Void doOnOpen(ChannelHandlerContext ctx, OpenRequest msg) throws XrootdException {
        this.authorize(ctx, msg, msg.getRequiredPermission());
        ctx.fireChannelRead((Object)msg);
        return null;
    }

    @Override
    protected Void doOnRead(ChannelHandlerContext ctx, ReadRequest msg) throws XrootdException {
        ctx.fireChannelRead((Object)msg);
        return null;
    }

    @Override
    protected Void doOnReadV(ChannelHandlerContext ctx, ReadVRequest msg) throws XrootdException {
        ctx.fireChannelRead((Object)msg);
        return null;
    }

    @Override
    protected Void doOnWrite(ChannelHandlerContext ctx, WriteRequest msg) throws XrootdException {
        ctx.fireChannelRead((Object)msg);
        return null;
    }

    @Override
    protected Void doOnSync(ChannelHandlerContext ctx, SyncRequest msg) throws XrootdException {
        ctx.fireChannelRead((Object)msg);
        return null;
    }

    @Override
    protected Void doOnClose(ChannelHandlerContext ctx, CloseRequest msg) throws XrootdException {
        ctx.fireChannelRead((Object)msg);
        return null;
    }

    @Override
    protected Void doOnProtocolRequest(ChannelHandlerContext ctx, ProtocolRequest msg) throws XrootdException {
        ctx.fireChannelRead((Object)msg);
        return null;
    }

    @Override
    protected Void doOnQuery(ChannelHandlerContext ctx, QueryRequest req) throws XrootdException {
        switch (req.getReqcode()) {
            case 3: 
            case 4: {
                req.setPath(this.authorize(ctx, req, XrootdProtocol.FilePerm.READ, req.getPath(), req.getOpaque()));
            }
        }
        ctx.fireChannelRead((Object)req);
        return null;
    }

    @Override
    protected Void doOnSet(ChannelHandlerContext ctx, SetRequest request) throws XrootdException {
        ctx.fireChannelRead((Object)request);
        return null;
    }

    private void authorize(ChannelHandlerContext ctx, PathRequest request, XrootdProtocol.FilePerm neededPerm) throws XrootdException {
        request.setPath(this.authorize(ctx, request, neededPerm, request.getPath(), request.getOpaque()));
    }

    private String authorize(ChannelHandlerContext ctx, XrootdRequest request, XrootdProtocol.FilePerm neededPerm, String path, String opaque) throws XrootdException {
        try {
            InetSocketAddress destinationAddress = this.getDestinationAddress();
            InetSocketAddress sourceAddress = this.getSourceAddress();
            AuthorizationHandler handler = this._authorizationFactory.createHandler(ctx);
            return handler.authorize(request.getSubject(), destinationAddress, sourceAddress, path, OpaqueStringParser.getOpaqueMap(opaque), request.getRequestId(), neededPerm);
        }
        catch (GeneralSecurityException e) {
            throw new XrootdException(3010, "Authorization check failed: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new XrootdException(3010, "Permission denied: " + e.getMessage());
        }
        catch (ParseException e) {
            throw new XrootdException(3006, "Invalid opaque data: " + e.getMessage());
        }
    }
}

