/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.dcache.xrootd.core.XrootdException;

public class SecurityInfo {
    private final String protocol;
    private final Map<String, String> data;
    private final String description;

    public SecurityInfo(String description) throws XrootdException {
        this.description = description;
        int comma = description.indexOf(44);
        if (comma == -1) {
            this.protocol = description.trim();
            this.data = Collections.emptyMap();
        } else {
            String[] kvPairs;
            this.protocol = description.substring(0, comma);
            this.data = new HashMap<String, String>();
            String keyValueData = description.substring(comma + 1);
            for (String pair : kvPairs = keyValueData.split(",")) {
                String[] keyValue = pair.split(":");
                if (keyValue.length == 2) {
                    this.data.put(keyValue[0], keyValue[1]);
                    continue;
                }
                this.data.put(keyValue[0], keyValue[0]);
            }
        }
        if (this.protocol.isEmpty()) {
            throw new XrootdException(3001, "Missing protocol name");
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String toString() {
        return this.description;
    }

    public Optional<String> getValue(String key) {
        return Optional.ofNullable(this.data.get(key));
    }

    public String getRequiredValue(String key) throws XrootdException {
        String value = this.data.get(key);
        if (value == null) {
            throw new XrootdException(3001, "missing '" + key + "' in sec");
        }
        return value;
    }
}

