/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Map;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdOutboundRequest;
import org.dcache.xrootd.tpc.protocol.messages.OutboundOpenReadOnlyRequest;

public class SigningPolicy {
    public static final SigningPolicy OFF = new SigningPolicy();
    private final int secLvl;
    private final Map<Integer, Integer> overrides;
    private final byte secOFrce;

    public SigningPolicy() {
        this(0, Collections.EMPTY_MAP);
    }

    public SigningPolicy(int secLvl, boolean force) {
        this(secLvl, force ? (byte)2 : 0, Collections.EMPTY_MAP);
    }

    public SigningPolicy(int secLvl, Map<Integer, Integer> overrides) {
        this(secLvl, 0, overrides);
    }

    public SigningPolicy(int secLvl, byte secOFrce, Map<Integer, Integer> overrides) {
        this.secLvl = secLvl;
        this.secOFrce = secOFrce;
        this.overrides = overrides;
    }

    public boolean isForceSigning() {
        return this.secOFrce == 2;
    }

    public boolean isSigningOn() {
        return this.secLvl > 0;
    }

    public boolean requiresSigning(XrootdRequest request) {
        int requestId = request.getRequestId();
        boolean readOnly = requestId == 3010 && ((OpenRequest)request).isReadOnly();
        return this.requiresSigning(requestId, readOnly);
    }

    public boolean requiresSigning(AbstractXrootdOutboundRequest request) {
        boolean readOnly = request instanceof OutboundOpenReadOnlyRequest;
        return this.requiresSigning(request.getRequestId(), readOnly);
    }

    public String toString() {
        return "(secLvl " + this.secLvl + ")(overrides " + this.overrides + ")(force " + this.isForceSigning() + ")";
    }

    public void writeBytes(ByteBuf buffer) {
        buffer.writeByte((int)this.secOFrce);
        buffer.writeByte(this.secLvl);
        buffer.writeByte(this.overrides.size());
        for (Map.Entry<Integer, Integer> entry : this.overrides.entrySet()) {
            buffer.writeByte(entry.getKey().intValue());
            buffer.writeByte(entry.getValue().intValue());
        }
    }

    private boolean requiresSigning(int requestId, boolean readOnly) {
        int signingLevel;
        Integer override = this.overrides.get(requestId);
        if (override == null) {
            override = 0;
        }
        switch (requestId) {
            case 3001: 
            case 3004: 
            case 3013: 
            case 3016: 
            case 3017: 
            case 3021: 
            case 3022: 
            case 3025: 
            case 3027: {
                signingLevel = 4;
                break;
            }
            case 3003: 
            case 3018: 
            case 3019: 
            case 3023: 
            case 3024: 
            case 3026: 
            case 3031: {
                signingLevel = 3;
                break;
            }
            case 3008: {
                signingLevel = 2;
                break;
            }
            case 3010: {
                if (readOnly) {
                    signingLevel = 2;
                    break;
                }
                signingLevel = 1;
                break;
            }
            case 3002: 
            case 3005: 
            case 3009: 
            case 3012: 
            case 3014: 
            case 3015: 
            case 3020: 
            case 3028: {
                signingLevel = 1;
                break;
            }
            default: {
                signingLevel = 0;
            }
        }
        return signingLevel != 0 && (this.secLvl >= signingLevel || override == 2);
    }
}

