/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.tpc.XrootdTpcClient;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundAttnResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundAuthenticationResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundChecksumResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundCloseResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundErrorResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundHandshakeResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundLoginResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundOpenReadOnlyResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundProtocolResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundReadResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundRedirectResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundWaitRespResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundWaitResponse;
import org.dcache.xrootd.tpc.protocol.messages.OutboundAuthenticationRequest;
import org.dcache.xrootd.tpc.protocol.messages.OutboundChecksumRequest;
import org.dcache.xrootd.tpc.protocol.messages.OutboundCloseRequest;
import org.dcache.xrootd.tpc.protocol.messages.OutboundLoginRequest;
import org.dcache.xrootd.tpc.protocol.messages.OutboundOpenReadOnlyRequest;
import org.dcache.xrootd.tpc.protocol.messages.OutboundReadRequest;
import org.dcache.xrootd.tpc.protocol.messages.XrootdInboundResponse;
import org.dcache.xrootd.tpc.protocol.messages.XrootdOutboundRequest;
import org.dcache.xrootd.util.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientRequestHandler
extends ChannelInboundHandlerAdapter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractClientRequestHandler.class);
    protected XrootdTpcClient client;
    protected ScheduledFuture future;

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof XrootdInboundResponse) {
            this.client.stopTimer();
            this.responseReceived(ctx, (XrootdInboundResponse)msg);
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) {
        if (t instanceof ClosedChannelException) {
            LOGGER.warn("ClosedChannelException caught on channel {}.", (Object)ctx.channel().id());
        } else if (t instanceof IOException) {
            LOGGER.error("IOException caught on channel {}: {}.", (Object)ctx.channel().id(), (Object)t.toString());
        } else if (t instanceof XrootdException) {
            LOGGER.error("Exception caught on channel {}: {}.", (Object)ctx.channel().id(), (Object)t.toString());
        } else {
            LOGGER.error("Exception caught on channel {}: {}", (Object)ctx.channel().id(), (Object)t.getMessage());
            Thread me = Thread.currentThread();
            me.getUncaughtExceptionHandler().uncaughtException(me, t);
        }
        if (this.client != null) {
            this.client.setError(t);
            this.client.shutDown(ctx);
        }
    }

    public void setClient(XrootdTpcClient client) {
        this.client = client;
    }

    protected void asynWaitTimeout(ChannelHandlerContext ctx, InboundWaitRespResponse response) {
        String message = String.format("waited %d secs for server attn, never received response.", this.getWaitInSeconds(response));
        LOGGER.error("Channel {}: {}.", (Object)ctx.channel().id(), (Object)message);
        if (this.client != null) {
            this.client.setError(new XrootdException(10000, message));
            this.client.shutDown(ctx);
        }
    }

    protected void doOnAsynResponse(ChannelHandlerContext ctx, InboundAttnResponse response) throws XrootdException {
        switch (response.getRequestId()) {
            case 3023: {
                this.client.doEndsession(ctx);
                break;
            }
            default: {
                ctx.fireChannelRead((Object)response);
            }
        }
    }

    protected void doOnAuthenticationResponse(ChannelHandlerContext ctx, InboundAuthenticationResponse response) throws XrootdException {
        LOGGER.debug("doOnAuthenticationResponse, channel {}, stream {} \u2013\u2013 passing to next in chain.", (Object)ctx.channel().id(), (Object)response.getStreamId());
        ctx.fireChannelRead((Object)response);
    }

    protected void doOnChecksumResponse(ChannelHandlerContext ctx, InboundChecksumResponse response) throws XrootdException {
        LOGGER.debug("doOnChecksumResponse, channel {}, stream {} \u2013\u2013 passing to next in chain.", (Object)ctx.channel().id(), (Object)response.getStreamId());
        ctx.fireChannelRead((Object)response);
    }

    protected void doOnCloseResponse(ChannelHandlerContext ctx, InboundCloseResponse response) throws XrootdException {
        LOGGER.debug("doOnCloseResponse, channel {}, stream {} \u2013\u2013 passing to next in chain.", (Object)ctx.channel().id(), (Object)response.getStreamId());
        ctx.fireChannelRead((Object)response);
    }

    protected void doOnErrorResponse(ChannelHandlerContext ctx, InboundErrorResponse response) throws XrootdException {
        throw new XrootdException(response.getError(), response.getErrorMessage());
    }

    protected void doOnHandshakeResponse(ChannelHandlerContext ctx, InboundHandshakeResponse response) throws XrootdException {
        LOGGER.debug("doOnHandshakeResponse, channel {} \u2013\u2013 passing to next in chain.", (Object)ctx.channel().id());
        ctx.fireChannelRead((Object)response);
    }

    protected void doOnLoginResponse(ChannelHandlerContext ctx, InboundLoginResponse response) throws XrootdException {
        LOGGER.debug("doOnLoginResponse, channel {}, stream {} \u2013\u2013 passing to next in chain.", (Object)ctx.channel().id(), (Object)response.getStreamId());
        ctx.fireChannelRead((Object)response);
    }

    protected void doOnOpenResponse(ChannelHandlerContext ctx, InboundOpenReadOnlyResponse response) throws XrootdException {
        LOGGER.debug("doOnOpenResponse, channel {}, stream {} \u2013\u2013 passing to next in chain.", (Object)ctx.channel().id(), (Object)response.getStreamId());
        ctx.fireChannelRead((Object)response);
    }

    protected void doOnProtocolResponse(ChannelHandlerContext ctx, InboundProtocolResponse response) throws XrootdException {
        LOGGER.debug("doOnProtocolResponse, channel {}, stream {} \u2013\u2013 passing to next in chain.", (Object)ctx.channel().id(), (Object)response.getStreamId());
        ctx.fireChannelRead((Object)response);
    }

    protected void doOnReadResponse(ChannelHandlerContext ctx, InboundReadResponse response) throws XrootdException {
        LOGGER.debug("doOnReadResponse, channel {}, stream {} \u2013\u2013 passing to next in chain.", (Object)ctx.channel().id(), (Object)response.getStreamId());
        ctx.fireChannelRead((Object)response);
    }

    protected void doOnRedirectResponse(ChannelHandlerContext ctx, InboundRedirectResponse response) throws XrootdException {
        ChannelId id = ctx.channel().id();
        LOGGER.debug("redirecting client from {} to {}:{}, channel {}, stream {}; [info {}].", new Object[]{this.client.getInfo().getSrc(), response.getHost(), response.getPort(), id, this.client.getStreamId(), this.client.getInfo()});
        this.client.getWriteHandler().redirect(ctx, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOnAttnResponse(ChannelHandlerContext ctx, InboundAttnResponse response) throws XrootdException {
        switch (response.getActnum()) {
            case 5000: {
                String message = "Received abort from source server: " + response.getMessage();
                throw new XrootdException(3012, message);
            }
            case 5002: {
                LOGGER.info("Received from source server: {}.", (Object)response.getMessage());
                break;
            }
            case 5007: 
            case 5008: {
                AbstractClientRequestHandler abstractClientRequestHandler = this;
                synchronized (abstractClientRequestHandler) {
                    if (this.future != null) {
                        this.future.cancel(true);
                        this.doOnAsynResponse(ctx, response);
                        this.future = null;
                    }
                    break;
                }
            }
            case 5004: {
                this.doOnWaitResponse(ctx, response);
                break;
            }
            case 5001: 
            case 5003: {
                try {
                    this.doOnRedirectResponse(ctx, new InboundRedirectResponse(response));
                    break;
                }
                catch (ParseException e) {
                    throw new XrootdException(3006, "bad redirect data from kXR_asyncdi");
                }
            }
            case 5005: 
            case 5006: {
                throw new XrootdException(3013, "tpc client does not support this option: " + response.getActnum());
            }
            default: {
                throw new XrootdException(3000, "unrecognized kXR_attn action: " + response.getActnum());
            }
        }
    }

    protected synchronized void doOnWaitResponse(ChannelHandlerContext ctx, AbstractXrootdInboundResponse response) throws XrootdException {
        switch (response.getRequestId()) {
            case 3023: {
                this.future = this.client.getExecutor().schedule(() -> this.client.doEndsession(ctx), (long)this.getWaitInSeconds(response), TimeUnit.SECONDS);
                break;
            }
            default: {
                ctx.fireChannelRead((Object)response);
            }
        }
    }

    protected synchronized void doOnWaitRespResponse(ChannelHandlerContext ctx, InboundWaitRespResponse response) throws XrootdException {
        this.future = this.client.getExecutor().schedule(() -> this.asynWaitTimeout(ctx, response), (long)this.getWaitInSeconds(response), TimeUnit.SECONDS);
    }

    protected int getWaitInSeconds(AbstractXrootdInboundResponse response) {
        int wsec = 0;
        int msec = 0;
        if (response instanceof InboundWaitResponse) {
            msec = ((InboundWaitResponse)response).getMaxWaitInSeconds();
            wsec = 10;
        } else if (response instanceof InboundWaitRespResponse) {
            wsec = msec = ((InboundWaitRespResponse)response).getMaxWaitInSeconds();
        } else if (response instanceof InboundAttnResponse) {
            InboundAttnResponse attnResponse = (InboundAttnResponse)response;
            msec = wsec = attnResponse.getWsec();
        }
        return Math.min(wsec, msec);
    }

    protected void responseReceived(ChannelHandlerContext ctx, XrootdInboundResponse response) {
        try {
            if (response instanceof InboundWaitResponse) {
                this.doOnWaitResponse(ctx, (InboundWaitResponse)response);
                return;
            }
            if (response instanceof InboundWaitRespResponse) {
                this.doOnWaitRespResponse(ctx, (InboundWaitRespResponse)response);
                return;
            }
            if (response instanceof InboundErrorResponse) {
                this.doOnErrorResponse(ctx, (InboundErrorResponse)response);
                return;
            }
            if (response instanceof InboundRedirectResponse) {
                this.doOnRedirectResponse(ctx, (InboundRedirectResponse)response);
                return;
            }
            if (response instanceof InboundAttnResponse) {
                this.doOnAttnResponse(ctx, (InboundAttnResponse)response);
                return;
            }
            int streamId = response.getStreamId();
            ChannelId id = ctx.channel().id();
            int requestId = response.getRequestId();
            switch (requestId) {
                case 3000: {
                    LOGGER.debug("responseReceived, channel {}, stream {}, requestId = kXR_auth.", (Object)id, (Object)streamId);
                    this.doOnAuthenticationResponse(ctx, (InboundAuthenticationResponse)response);
                    break;
                }
                case 3003: {
                    LOGGER.debug("responseReceived, channel {}, stream {}, requestId = kXR_close.", (Object)id, (Object)streamId);
                    this.doOnCloseResponse(ctx, (InboundCloseResponse)response);
                    break;
                }
                case 3023: {
                    LOGGER.debug("responseReceived, channel {}, stream {}, requestId = kXR_endsess.", (Object)id, (Object)streamId);
                    LOGGER.debug("endsession response received.");
                    this.client.disconnect();
                    break;
                }
                case 0: {
                    LOGGER.debug("responseReceived, channel {}, stream {}, requestId = kXR_handshake.", (Object)id, (Object)streamId);
                    this.doOnHandshakeResponse(ctx, (InboundHandshakeResponse)response);
                    break;
                }
                case 3007: {
                    LOGGER.debug("responseReceived, channel {}, stream {}, requestId = kXR_login.", (Object)id, (Object)streamId);
                    this.doOnLoginResponse(ctx, (InboundLoginResponse)response);
                    break;
                }
                case 3010: {
                    LOGGER.debug("responseReceived, channel {}, stream {}, requestId = kXR_open.", (Object)id, (Object)streamId);
                    this.doOnOpenResponse(ctx, (InboundOpenReadOnlyResponse)response);
                    break;
                }
                case 3006: {
                    LOGGER.debug("responseReceived, channel {}, stream {}, requestId = kXR_protocol.", (Object)id, (Object)streamId);
                    this.doOnProtocolResponse(ctx, (InboundProtocolResponse)response);
                    break;
                }
                case 3001: {
                    LOGGER.debug("responseReceived, channel {}, stream {}, requestId = kXR_query.", (Object)id, (Object)streamId);
                    this.doOnChecksumResponse(ctx, (InboundChecksumResponse)response);
                    break;
                }
                case 3013: {
                    LOGGER.debug("responseReceived, channel {}, stream {}, requestId = kXR_read.", (Object)id, (Object)streamId);
                    this.doOnReadResponse(ctx, (InboundReadResponse)response);
                    break;
                }
                default: {
                    String error = String.format("Response (channel %s, stream %d, request %s) should not have been received by tpc client; this is a bug;please report to support@dcache.org.", id, streamId, requestId);
                    throw new RuntimeException(error);
                }
            }
        }
        catch (Throwable t) {
            this.exceptionCaught(ctx, t);
        }
    }

    protected void sendAuthenticationRequest(ChannelHandlerContext ctx) throws XrootdException {
        this.unsupported(OutboundAuthenticationRequest.class);
    }

    protected void sendChecksumRequest(ChannelHandlerContext ctx) throws XrootdException {
        this.unsupported(OutboundChecksumRequest.class);
    }

    protected void sendCloseRequest(ChannelHandlerContext ctx) throws XrootdException {
        this.unsupported(OutboundCloseRequest.class);
    }

    protected void sendLoginRequest(ChannelHandlerContext ctx) throws XrootdException {
        this.unsupported(OutboundLoginRequest.class);
    }

    protected void sendOpenRequest(ChannelHandlerContext ctx) throws XrootdException {
        this.unsupported(OutboundOpenReadOnlyRequest.class);
    }

    protected void sendReadRequest(ChannelHandlerContext ctx) throws XrootdException {
        this.unsupported(OutboundReadRequest.class);
    }

    protected <T extends XrootdOutboundRequest> void unsupported(Class<T> msg) throws XrootdException {
        LOGGER.warn("Unsupported request: " + msg.getSimpleName());
        throw new XrootdException(3013, "request " + msg.getSimpleName() + " not supported");
    }
}

