/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.util;

import java.util.Map;
import java.util.Optional;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.util.OpaqueStringParser;
import org.dcache.xrootd.util.ParseException;

public class ChecksumInfo {
    private static final String KEY = "cks.type";
    private final String path;
    private final Optional<String> type;

    public ChecksumInfo(String path, String opaque) throws XrootdException {
        this.path = path;
        if (opaque == null) {
            this.type = Optional.empty();
        } else {
            try {
                Map<String, String> map = OpaqueStringParser.getOpaqueMap(opaque);
                this.type = Optional.ofNullable(map.get(KEY));
            }
            catch (ParseException e) {
                throw new XrootdException(3006, "malformed checksum query part: " + opaque);
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public Optional<String> getType() {
        return this.type;
    }
}

