/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import com.google.common.collect.Maps;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.core.XrootdSession;
import org.dcache.xrootd.core.XrootdSessionIdentifier;
import org.dcache.xrootd.core.XrootdSigverDecoder;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.InvalidHandlerConfigurationException;
import org.dcache.xrootd.plugins.ProxyDelegationClient;
import org.dcache.xrootd.plugins.authn.none.NoAuthenticationHandler;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.EndSessionRequest;
import org.dcache.xrootd.protocol.messages.ErrorResponse;
import org.dcache.xrootd.protocol.messages.LoginRequest;
import org.dcache.xrootd.protocol.messages.LoginResponse;
import org.dcache.xrootd.protocol.messages.OkResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;
import org.dcache.xrootd.security.BufferDecrypter;
import org.dcache.xrootd.security.RequiresTLS;
import org.dcache.xrootd.security.SigningPolicy;
import org.dcache.xrootd.security.TLSSessionInfo;
import org.dcache.xrootd.util.UserNameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdAuthenticationHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger _log = LoggerFactory.getLogger(XrootdAuthenticationHandler.class);
    private static final ConcurrentMap<XrootdSessionIdentifier, XrootdSession> _sessions = Maps.newConcurrentMap();
    private static final XrootdSessionIdentifier CURRENT_SESSION_PLACEHOLDER = new XrootdSessionIdentifier(new byte[16]);
    private final AtomicBoolean _isInProgress = new AtomicBoolean(false);
    private final XrootdSessionIdentifier _sessionId = new XrootdSessionIdentifier();
    private final AuthenticationFactory _authenticationFactory;
    private final ProxyDelegationClient _proxyDelegationClient;
    private TLSSessionInfo _tlsSessionInfo;
    private SigningPolicy _signingPolicy;
    private AuthenticationHandler _authenticationHandler;
    private volatile State _state = State.NO_LOGIN;
    private XrootdSession _session;

    public XrootdAuthenticationHandler(AuthenticationFactory authenticationFactory, ProxyDelegationClient proxyDelegationClient) {
        this._authenticationFactory = authenticationFactory;
        this._proxyDelegationClient = proxyDelegationClient;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        _sessions.remove(this._sessionId);
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof XrootdRequest)) {
            super.channelRead(ctx, msg);
            return;
        }
        XrootdRequest request = (XrootdRequest)msg;
        int reqId = request.getRequestId();
        try {
            switch (reqId) {
                case 3007: {
                    try {
                        if (this._isInProgress.compareAndSet(false, true)) {
                            try {
                                this._state = State.NO_LOGIN;
                                LoginRequest loginRequest = (LoginRequest)request;
                                loginRequest.setUserName(UserNameUtils.checkUsernameValid(loginRequest.getUserName()));
                                this._session = new XrootdSession(this._sessionId, ctx.channel(), loginRequest);
                                request.setSession(this._session);
                                this.doOnLogin(ctx, loginRequest);
                                _sessions.put(this._sessionId, this._session);
                                break;
                            }
                            finally {
                                this._isInProgress.set(false);
                            }
                        }
                        throw new XrootdException(3020, "Login in progress");
                    }
                    finally {
                        ReferenceCountUtil.release((Object)request);
                    }
                }
                case 3000: {
                    try {
                        if (this._isInProgress.compareAndSet(false, true)) {
                            try {
                                switch (this._state) {
                                    case NO_LOGIN: {
                                        throw new XrootdException(3010, "Login required");
                                    }
                                    case AUTH: {
                                        throw new XrootdException(3006, "Already authenticated");
                                    }
                                }
                                request.setSession(this._session);
                                this.doOnAuthentication(ctx, (AuthenticationRequest)request);
                                break;
                            }
                            finally {
                                this._isInProgress.set(false);
                            }
                        }
                        throw new XrootdException(3020, "Login in progress");
                    }
                    finally {
                        ReferenceCountUtil.release((Object)request);
                    }
                }
                case 3023: {
                    try {
                        switch (this._state) {
                            case NO_LOGIN: {
                                throw new XrootdException(3010, "Login required");
                            }
                            case NO_AUTH: {
                                throw new XrootdException(3010, "Authentication required");
                            }
                        }
                        this.doOnEndSession(ctx, (EndSessionRequest)request);
                        break;
                    }
                    finally {
                        ReferenceCountUtil.release((Object)request);
                    }
                }
                case 3024: {
                    if (this._tlsSessionInfo != null && this._tlsSessionInfo.serverUsesTls()) {
                        boolean isStarted = this._tlsSessionInfo.serverTransitionedToTLS(3024, ctx);
                        _log.debug("kXR_bind, server has now transitioned to tls? {}.", (Object)isStarted);
                    }
                    super.channelRead(ctx, msg);
                    break;
                }
                case 3006: {
                    request.setSession(this._session);
                    super.channelRead(ctx, msg);
                    break;
                }
                case 3011: {
                    if (this._state == State.NO_LOGIN) {
                        ReferenceCountUtil.release((Object)request);
                        throw new XrootdException(3010, "Login required");
                    }
                    request.setSession(this._session);
                    super.channelRead(ctx, msg);
                    break;
                }
                default: {
                    switch (this._state) {
                        case NO_LOGIN: {
                            ReferenceCountUtil.release((Object)request);
                            throw new XrootdException(3010, "Login required");
                        }
                        case NO_AUTH: {
                            ReferenceCountUtil.release((Object)request);
                            throw new XrootdException(3010, "Authentication required");
                        }
                    }
                    request.setSession(this._session);
                    super.channelRead(ctx, msg);
                }
            }
        }
        catch (XrootdException e) {
            ErrorResponse<XrootdRequest> error = new ErrorResponse<XrootdRequest>(ctx, request, e.getError(), e.getMessage());
            ctx.writeAndFlush(error);
        }
        catch (RuntimeException e) {
            _log.error("xrootd server error while processing " + msg + " (please report this to support@dcache.org)", (Throwable)e);
            ErrorResponse<XrootdRequest> error = new ErrorResponse<XrootdRequest>(ctx, request, 3012, String.format("Internal server error (%s)", e.getMessage()));
            ctx.writeAndFlush(error);
        }
    }

    public ProxyDelegationClient getCredentialStoreClient() {
        return this._proxyDelegationClient;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this._proxyDelegationClient != null) {
            this._proxyDelegationClient.close();
        }
    }

    public void setSigningPolicy(SigningPolicy signingPolicy) {
        this._signingPolicy = signingPolicy;
    }

    public void setTlsSessionInfo(TLSSessionInfo tlsSessionInfo) {
        this._tlsSessionInfo = tlsSessionInfo;
    }

    protected Subject login(ChannelHandlerContext context, Subject subject) throws XrootdException {
        return subject;
    }

    private void doOnLogin(ChannelHandlerContext context, LoginRequest request) throws XrootdException {
        try {
            this._authenticationHandler = this._authenticationFactory.createHandler(this._proxyDelegationClient);
            if (this._authenticationHandler instanceof RequiresTLS && !TLSSessionInfo.isTLSOn(context)) {
                throw new XrootdException(3013, "TLS is required for " + this._authenticationHandler.getProtocol());
            }
            LoginResponse response = new LoginResponse(request, this._sessionId, this._authenticationHandler.getProtocol());
            if (this._authenticationHandler.isCompleted()) {
                this.authenticated(context, this._authenticationHandler.getSubject());
            } else {
                this._state = State.NO_AUTH;
            }
            context.writeAndFlush((Object)response);
        }
        catch (InvalidHandlerConfigurationException e) {
            _log.error("Could not instantiate authentication handler: {}", (Throwable)e);
            throw new XrootdException(3012, "Internal server error");
        }
    }

    private void doOnAuthentication(ChannelHandlerContext context, AuthenticationRequest request) throws XrootdException {
        XrootdResponse<AuthenticationRequest> response = this._authenticationHandler.authenticate(request);
        if (this._authenticationHandler.isCompleted()) {
            this._state = State.NO_LOGIN;
            this.authenticated(context, this._authenticationHandler.getSubject());
        }
        context.writeAndFlush(response);
    }

    private void doOnEndSession(ChannelHandlerContext ctx, EndSessionRequest request) throws XrootdException {
        XrootdSessionIdentifier id = request.getSessionId();
        if (id.equals(CURRENT_SESSION_PLACEHOLDER)) {
            ctx.writeAndFlush(new OkResponse<EndSessionRequest>(request));
            ctx.channel().close();
            return;
        }
        XrootdSession session = (XrootdSession)_sessions.get(id);
        if (session != null) {
            if (!session.hasOwner(this._session.getSubject())) {
                throw new XrootdException(3010, "not session owner");
            }
            session.getChannel().close();
        }
        ctx.writeAndFlush(new OkResponse<EndSessionRequest>(request));
    }

    private void authenticated(ChannelHandlerContext context, Subject subject) throws XrootdException {
        this._session.setSubject(this.login(context, subject));
        this._state = State.AUTH;
        if (this._tlsSessionInfo != null && this._tlsSessionInfo.serverUsesTls()) {
            boolean isStarted = this._tlsSessionInfo.serverTransitionedToTLS(3000, context);
            _log.debug("kXR_auth, server has now transitioned to tls? {}.", (Object)isStarted);
        } else if (!(this._authenticationHandler instanceof NoAuthenticationHandler) && !TLSSessionInfo.isTLSOn(context) && this._signingPolicy.isSigningOn()) {
            BufferDecrypter decrypter = this._authenticationHandler.getDecrypter();
            context.pipeline().addAfter("decoder", "sigverDecoder", (ChannelHandler)new XrootdSigverDecoder(this._signingPolicy, decrypter));
            context.pipeline().remove("decoder");
            _log.debug("switched decoder to sigverDecoder, decrypter {}.", (Object)decrypter);
        }
        this._authenticationHandler = null;
    }

    private static enum State {
        NO_LOGIN,
        NO_AUTH,
        AUTH;

    }
}

