/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.dcache.xrootd.core.AbstractXrootdDecoder;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.protocol.messages.ErrorResponse;
import org.dcache.xrootd.protocol.messages.SigverRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.security.BufferDecrypter;
import org.dcache.xrootd.security.SigningPolicy;

public class XrootdSigverDecoder
extends AbstractXrootdDecoder {
    private final BufferDecrypter decryptionHandler;
    private final SigningPolicy signingPolicy;
    private SigverRequest currentSigverRequest;
    private long lastSeqNo = -1L;

    private static String printHex(byte[] array) {
        Formatter formatter = new Formatter();
        for (byte b : array) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    public XrootdSigverDecoder(SigningPolicy signingPolicy, BufferDecrypter decryptionHandler) {
        this.signingPolicy = signingPolicy;
        this.decryptionHandler = decryptionHandler;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        int length = this.verifyMessageLength(in);
        if (length < 0) {
            ctx.channel().close();
            return;
        }
        if (length == 0) {
            return;
        }
        ByteBuf frame = in.readSlice(length);
        XrootdRequest request = this.getRequest(frame);
        try {
            if (request instanceof SigverRequest) {
                this.setSigver((SigverRequest)request);
                return;
            }
            int requestId = request.getRequestId();
            if (this.signingPolicy.requiresSigning(request)) {
                this.verifySignedHash(request.getStreamId(), requestId, frame, ctx);
            }
        }
        catch (XrootdException e) {
            ErrorResponse<XrootdRequest> response = new ErrorResponse<XrootdRequest>(ctx, request, e.getError(), Strings.nullToEmpty((String)e.getMessage()));
            ctx.writeAndFlush(response).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            return;
        }
        out.add(request);
    }

    private void setSigver(SigverRequest request) throws XrootdException {
        if (request.getSeqno() <= this.lastSeqNo) {
            throw new XrootdException(3022, "signed hash verification: bad sequence number.");
        }
        if (request.getVersion() != 0) {
            throw new XrootdException(3022, "signed hash verification: unsupported version number.");
        }
        if (request.isRSAKey()) {
            throw new XrootdException(3022, "signed hash verification: unsupported use of RSA key.");
        }
        if (!request.isSHA256()) {
            throw new XrootdException(3022, "signed hash verification: unsupported crypto hash.");
        }
        this.currentSigverRequest = request;
    }

    private void verifySignedHash(int streamId, int requestId, ByteBuf frame, ChannelHandlerContext ctx) throws XrootdException {
        boolean forceSigning = this.signingPolicy.isForceSigning();
        LOGGER.debug("calling verify signed hash for request {} on stream {}, force {}.", new Object[]{requestId, streamId, forceSigning});
        if (this.currentSigverRequest == null) {
            if (this.decryptionHandler != null || forceSigning) {
                throw new XrootdException(3022, "signed hash verification: did not receive preceding sigver request.");
            }
            LOGGER.debug("skipping verify signed hash for request {} on stream {}.", (Object)requestId, (Object)streamId);
            return;
        }
        if (this.currentSigverRequest.getStreamId() != streamId) {
            throw new XrootdException(3022, "signed hash verification: stream id mismatch.");
        }
        if (this.currentSigverRequest.getExpectrid() != requestId) {
            throw new XrootdException(3022, "signed hash verification: request id mismatch.");
        }
        byte[] received = null;
        if (this.decryptionHandler != null) {
            try {
                this.currentSigverRequest.decrypt(this.decryptionHandler);
                received = this.currentSigverRequest.getSignature();
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw new XrootdException(3023, e.toString());
            }
        } else if (forceSigning) {
            received = this.currentSigverRequest.getSignature();
        }
        if (received != null) {
            byte[] contents = this.extractContents(requestId, this.currentSigverRequest.getFlags(), frame);
            this.compareHashes(received, this.generateHash(this.currentSigverRequest.getSeqno(), contents, ctx));
        }
        LOGGER.debug("verify signed hash for request {} on stream {}, force {}, succeeded.", new Object[]{requestId, streamId, forceSigning});
        this.updateSeqNo();
    }

    private void compareHashes(byte[] received, byte[] generated) throws XrootdException {
        if (received.length != generated.length) {
            LOGGER.info("compareHashes, different lengths:\n\treceived {}\n\tgenerated {}", (Object)XrootdSigverDecoder.printHex(received), (Object)XrootdSigverDecoder.printHex(generated));
            throw new XrootdException(3022, "signed hash verification: received hash length does not match generated hash.");
        }
        if (!Arrays.equals(received, generated)) {
            LOGGER.info("compareHashes, do not match:\n\treceived {}\n\tgenerated {}", (Object)XrootdSigverDecoder.printHex(received), (Object)XrootdSigverDecoder.printHex(generated));
            throw new XrootdException(3022, "signed hash verification: received hash does not match generated hash.");
        }
    }

    private byte[] extractContents(int requestId, int flags, ByteBuf frame) throws XrootdException {
        int len;
        if (requestId == 3019) {
            if (flags != 1) {
                throw new XrootdException(3022, "signed hash verification: kXR_nodata not set, cannot verify write request.");
            }
            len = 24;
        } else {
            len = frame.readableBytes();
        }
        byte[] contents = new byte[len];
        frame.getBytes(0, contents);
        return contents;
    }

    private byte[] generateHash(long seqno, byte[] payload, ChannelHandlerContext ctx) throws XrootdException {
        ByteBuf buffer = ctx.alloc().buffer(8 + payload.length);
        try {
            buffer.writeLong(seqno);
            buffer.writeBytes(payload);
            byte[] contents = new byte[buffer.readableBytes()];
            buffer.getBytes(0, contents);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = digest.digest(contents);
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw new XrootdException(3022, e.toString());
        }
        finally {
            buffer.release();
        }
    }

    private void updateSeqNo() {
        this.lastSeqNo = this.currentSigverRequest.getSeqno();
        this.currentSigverRequest = null;
    }
}

