/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.core.XrootdSession;
import org.dcache.xrootd.protocol.XrootdProtocol;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponse<T extends XrootdRequest>
extends AbstractXrootdResponse<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorResponse.class);
    private final int errnum;
    private final String errmsg;

    public ErrorResponse(ChannelHandlerContext ctx, T request, int errnum, String errmsg) {
        super(request, 4003);
        this.errnum = errnum;
        this.errmsg = Strings.nullToEmpty((String)errmsg);
        XrootdSession session = request.getSession();
        int reqId = request.getRequestId();
        LOGGER.info("Xrootd-Error-Response: [session {}][connection {}][request {} {}](error {}, {}, {}).", new Object[]{session == null ? "?" : session.getSessionIdentifier(), ctx.channel(), reqId, XrootdProtocol.getClientRequest(reqId), errnum, XrootdProtocol.getServerError(errnum), errmsg});
    }

    public int getErrorNumber() {
        return this.errnum;
    }

    public String getErrorMessage() {
        return this.errmsg;
    }

    @Override
    public int getDataLength() {
        return 4 + this.errmsg.length() + 1;
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        buffer.writeInt(this.errnum);
        buffer.writeBytes(this.errmsg.getBytes(StandardCharsets.US_ASCII));
        buffer.writeByte(0);
    }

    public String toString() {
        return String.format("error[%d,%s]", this.errnum, this.errmsg);
    }
}

