/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.net.InetAddresses;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.LocateRequest;

public class LocateResponse
extends AbstractXrootdResponse<LocateRequest> {
    private final String encoded;

    public LocateResponse(LocateRequest request, InfoElement ... info) {
        this(request, LocateResponse.encode(request, info));
    }

    private LocateResponse(LocateRequest request, String encoded) {
        super(request, 0);
        this.encoded = encoded;
    }

    @Override
    public int getDataLength() {
        return this.encoded.length() + 1;
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        buffer.writeBytes(this.encoded.getBytes(StandardCharsets.US_ASCII));
        buffer.writeByte(0);
    }

    public String toString() {
        return "locate-reponse[" + this.encoded + "]";
    }

    private static String encode(LocateRequest request, InfoElement[] info) {
        boolean prefName = (request.getOptions() & 0x100) == 256;
        StringBuilder builder = new StringBuilder();
        Iterator it = Arrays.stream(info).iterator();
        if (it.hasNext()) {
            ((InfoElement)it.next()).append(builder, prefName);
        }
        while (it.hasNext()) {
            builder.append(" ");
            ((InfoElement)it.next()).append(builder, prefName);
        }
        return builder.toString();
    }

    public static class InfoElement {
        private final InetSocketAddress address;
        private final Node node;
        private final Access access;

        public InfoElement(InetSocketAddress address, Node node, Access access) {
            this.address = address;
            this.node = node;
            this.access = access;
        }

        public String toString() {
            return this.node.value + this.access.value + InetAddresses.toUriString((InetAddress)this.address.getAddress()) + ":" + this.address.getPort();
        }

        void append(StringBuilder builder, boolean preferName) {
            builder.append(this.node.value).append(this.access.value).append(preferName ? this.address.getHostName() : InetAddresses.toUriString((InetAddress)this.address.getAddress())).append(":").append(this.address.getPort());
        }
    }

    public static enum Access {
        READ("r"),
        WRITE("w");

        final String value;

        private Access(String value) {
            this.value = value;
        }
    }

    public static enum Node {
        MANAGER("M"),
        MANAGER_PENDING("m"),
        SERVER("S"),
        SERVER_PENDING("s");

        final String value;

        private Node(String value) {
            this.value = value;
        }
    }
}

