/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.ReadResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.stream.ChunkedResponse;

public abstract class AbstractChunkedReadResponse
implements ChunkedResponse {
    protected final ReadRequest request;
    protected final int maxFrameSize;
    protected long position;
    protected int length;
    protected boolean isEndOfInput;

    public AbstractChunkedReadResponse(ReadRequest request, int maxFrameSize) {
        this.request = request;
        this.maxFrameSize = maxFrameSize;
        this.position = request.getReadOffset();
        this.length = request.bytesToRead();
    }

    @Override
    public XrootdRequest getRequest() {
        return this.request;
    }

    public ReadResponse nextChunk(ByteBufAllocator alloc) throws Exception {
        if (this.isEndOfInput) {
            return null;
        }
        ByteBuf data = this.readNext(alloc);
        return new ReadResponse(this.request, data, !this.isEndOfInput);
    }

    private ByteBuf readNext(ByteBufAllocator alloc) throws IOException {
        int chunkLength = Math.min(this.length, this.maxFrameSize);
        ByteBuf buffer = this.read(alloc, this.position, chunkLength);
        int readableBytes = buffer.readableBytes();
        this.position += (long)readableBytes;
        int n = this.length = readableBytes < chunkLength ? 0 : this.length - readableBytes;
        if (this.length == 0) {
            this.isEndOfInput = true;
        }
        return buffer;
    }

    protected abstract ByteBuf read(ByteBufAllocator var1, long var2, int var4) throws IOException;

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.isEndOfInput;
    }

    @Override
    public void close() throws Exception {
    }
}

