/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc;

import com.google.common.base.Strings;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.core.XrootdSessionIdentifier;
import org.dcache.xrootd.plugins.ChannelHandlerFactory;
import org.dcache.xrootd.security.SecurityInfo;
import org.dcache.xrootd.security.SigningPolicy;
import org.dcache.xrootd.security.TLSSessionInfo;
import org.dcache.xrootd.tpc.AbstractClientRequestHandler;
import org.dcache.xrootd.tpc.TpcClientConnectHandler;
import org.dcache.xrootd.tpc.TpcDelayedSyncWriteHandler;
import org.dcache.xrootd.tpc.TpcSourceReadHandler;
import org.dcache.xrootd.tpc.XrootdTpcInfo;
import org.dcache.xrootd.tpc.core.XrootdClientDecoder;
import org.dcache.xrootd.tpc.core.XrootdClientEncoder;
import org.dcache.xrootd.tpc.protocol.messages.InboundAuthenticationResponse;
import org.dcache.xrootd.tpc.protocol.messages.OutboundCloseRequest;
import org.dcache.xrootd.tpc.protocol.messages.OutboundEndSessionRequest;
import org.dcache.xrootd.tpc.protocol.messages.OutboundHandshakeRequest;
import org.dcache.xrootd.util.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdTpcClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(XrootdTpcClient.class);
    private static final int DISCONNECT_TIMEOUT_IN_SECONDS = 5;
    private static final int DEFAULT_RESPONSE_TIMEOUT_IN_SECONDS = 30;
    private static int lastId = 1;
    private final int streamId = XrootdTpcClient.getNextStreamId();
    private final String userUrn;
    private final XrootdTpcInfo info;
    private final TpcDelayedSyncWriteHandler writeHandler;
    private final Map<String, ChannelHandler> authnHandlers;
    private final int pid;
    private final String uname;
    private final ScheduledExecutorService executorService;
    private int expectedRequestId;
    private SecurityInfo protocolInfo;
    private InboundAuthenticationResponse authResponse;
    private int pval;
    private int flag;
    private XrootdSessionIdentifier sessionId;
    private SigningPolicy signingPolicy;
    private TLSSessionInfo tlsSessionInfo;
    private int cpsize;
    private int cptype;
    private int fhandle;
    private boolean isOpenFile;
    private long writeOffset;
    private ChannelFuture channelFuture;
    private int errno;
    private String error;
    private boolean isRunning;
    private int redirects;
    private long timeOfFirstRedirect;
    private long responseTimeout = 30L;
    private ScheduledFuture timerTask;
    private ScheduledFuture attnFuture;

    private static synchronized int getClientPid() {
        return ThreadLocalRandom.current().nextInt(99999);
    }

    private static synchronized int getNextStreamId() {
        if (lastId < 0) {
            lastId = 1;
        }
        return lastId++;
    }

    public XrootdTpcClient(String userUrn, XrootdTpcInfo info, TpcDelayedSyncWriteHandler writeHandler, ScheduledExecutorService executorService) {
        this.info = info;
        this.writeHandler = writeHandler;
        this.expectedRequestId = 0;
        this.authnHandlers = new HashMap<String, ChannelHandler>();
        this.executorService = executorService;
        this.userUrn = userUrn;
        String user = userUrn.split("@")[0];
        String[] userSplit = user.split("[.]");
        this.uname = userSplit[0];
        this.pid = XrootdTpcClient.getClientPid();
        this.writeOffset = 0L;
        this.errno = 0;
        this.redirects = 0;
        this.timeOfFirstRedirect = 0L;
    }

    public synchronized boolean cancelAttnFuture() {
        if (this.attnFuture != null) {
            this.attnFuture.cancel(true);
            this.attnFuture = null;
            return true;
        }
        return false;
    }

    public synchronized boolean canRedirect() {
        return this.redirects < 256 || System.currentTimeMillis() - this.timeOfFirstRedirect < TimeUnit.MINUTES.toMillis(10L);
    }

    public void configureRedirects(XrootdTpcClient preceding) {
        this.redirects = preceding.redirects + 1;
        this.timeOfFirstRedirect = preceding.timeOfFirstRedirect <= 0L ? System.currentTimeMillis() : preceding.timeOfFirstRedirect;
        this.responseTimeout = preceding.responseTimeout;
    }

    public synchronized void connect(NioEventLoopGroup group, final List<ChannelHandlerFactory> plugins, final TpcSourceReadHandler readHandler) throws InterruptedException {
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                XrootdTpcClient.this.injectHandlers(ch.pipeline(), plugins, readHandler);
            }
        });
        try {
            this.channelFuture = b.connect(this.info.getSrcHost(), this.info.getSrcPort().intValue()).sync();
        }
        catch (Exception t) {
            this.setError(t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            return;
        }
        this.isRunning = true;
        this.notifyAll();
        this.sendHandshakeRequest(this.channelFuture.channel().pipeline().lastContext());
        LOGGER.info("Third-party client started for {}, channel {}. stream {}.", new Object[]{this.info.getSrc(), this.channelFuture.channel().id(), this.streamId});
    }

    public synchronized void disconnect() {
        if (!this.isRunning) {
            return;
        }
        ChannelId id = null;
        if (this.channelFuture != null) {
            id = this.channelFuture.channel().id();
            this.channelFuture.channel().close();
        }
        this.isRunning = false;
        this.notifyAll();
        LOGGER.info("Third-party client stopped, for {}, channel {}, stream {}.", new Object[]{this.info.getSrc(), id, this.streamId});
    }

    public void doClose(ChannelHandlerContext ctx) {
        LOGGER.debug("sendCloseRequest to {}, channel {}, stream {}, fhandle {}.", new Object[]{this.info.getSrc(), ctx.channel().id(), this.streamId, this.fhandle});
        this.expectedRequestId = 3003;
        ctx.writeAndFlush((Object)new OutboundCloseRequest(this.streamId, this.fhandle), ctx.newPromise()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void doEndsession(ChannelHandlerContext ctx) {
        if (this.sessionId != null) {
            LOGGER.debug("sendEndSessionRequest to {}, channel {}, stream {}, session {}.", new Object[]{this.info.getSrc(), ctx.channel().id(), this.streamId, this.sessionId});
            this.expectedRequestId = 3023;
            ctx.writeAndFlush((Object)new OutboundEndSessionRequest(this.streamId, this.sessionId), ctx.newPromise()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            this.sessionId = null;
        } else {
            LOGGER.debug("sendEndSessionRequest to {}, channel {}, stream {}, session was null.", new Object[]{this.info.getSrc(), ctx.channel().id(), this.streamId});
            this.disconnect();
        }
    }

    public ScheduledExecutorService getExecutor() {
        return this.executorService;
    }

    public synchronized void shutDown(ChannelHandlerContext ctx) {
        if (!this.isRunning) {
            return;
        }
        if (this.isOpenFile) {
            LOGGER.info("shutDown, doing close");
            this.doClose(ctx);
        } else {
            LOGGER.info("shutDown, doing endsession");
            this.doEndsession(ctx);
        }
        this.executorService.schedule(() -> this.disconnect(), 5L, TimeUnit.SECONDS);
    }

    public synchronized void startTimer(ChannelHandlerContext ctx) {
        this.stopTimer();
        this.timerTask = this.executorService.schedule(() -> {
            this.setError(this.getTimeoutException());
            this.shutDown(ctx);
        }, this.responseTimeout, TimeUnit.SECONDS);
    }

    public synchronized void stopTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel(true);
            this.timerTask = null;
        }
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public Map<String, ChannelHandler> getAuthnHandlers() {
        return this.authnHandlers;
    }

    public InboundAuthenticationResponse getAuthResponse() {
        return this.authResponse;
    }

    public int getCpsize() {
        return this.cpsize;
    }

    public int getCptype() {
        return this.cptype;
    }

    public int getErrno() {
        return this.errno;
    }

    public String getError() {
        return this.error;
    }

    public int getExpectedResponse() {
        return this.expectedRequestId;
    }

    public int getFhandle() {
        return this.fhandle;
    }

    public int getFlag() {
        return this.flag;
    }

    public String getFullpath() {
        String external;
        StringBuilder fullPath = new StringBuilder();
        String sourceToken = this.info.getSourceToken();
        if (sourceToken != null) {
            fullPath.append(XrootdTpcInfo.Cgi.AUTHZ.key()).append('=').append(sourceToken);
        }
        if (this.info.getDlgon() == XrootdTpcInfo.Delegation.OFF) {
            if (fullPath.length() > 0) {
                fullPath.append('&');
            }
            fullPath.append(XrootdTpcInfo.Cgi.CLIENT.key()).append('=').append(this.userUrn).append('&').append(XrootdTpcInfo.Cgi.RENDEZVOUS_KEY.key()).append('=').append(this.info.getKey());
        }
        if (!Strings.isNullOrEmpty((String)(external = this.info.getExternal()))) {
            if (fullPath.length() > 0) {
                fullPath.append('&');
            }
            fullPath.append(external);
        }
        if (fullPath.length() > 0) {
            fullPath.insert(0, '?');
        }
        fullPath.insert(0, this.info.getLfn());
        return fullPath.toString();
    }

    public XrootdTpcInfo getInfo() {
        return this.info;
    }

    public int getPid() {
        return this.pid;
    }

    public int getPval() {
        return this.pval;
    }

    public SecurityInfo getProtocolInfo() {
        return this.protocolInfo;
    }

    public XrootdSessionIdentifier getSessionId() {
        return this.sessionId;
    }

    public SigningPolicy getSigningPolicy() {
        return this.signingPolicy;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public TLSSessionInfo getTlsSessionInfo() {
        return this.tlsSessionInfo;
    }

    public String getUname() {
        return this.uname;
    }

    public String getUserUrn() {
        return this.userUrn;
    }

    public TpcDelayedSyncWriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    public long getWriteOffset() {
        return this.writeOffset;
    }

    public boolean isOpenFile() {
        return this.isOpenFile;
    }

    public synchronized void setAttnFuture(ScheduledFuture attnFuture) {
        this.attnFuture = attnFuture;
    }

    public void setAuthResponse(InboundAuthenticationResponse authResponse) {
        this.authResponse = authResponse;
    }

    public void setCpsize(int cpsize) {
        this.cpsize = cpsize;
    }

    public void setCptype(int cptype) {
        this.cptype = cptype;
    }

    public void setError(Throwable t) {
        this.error = t.getMessage();
        if (t instanceof XrootdException) {
            this.errno = ((XrootdException)t).getError();
        } else if (t instanceof UnknownHostException) {
            this.error = "Invalid address: " + this.error;
            this.errno = 3005;
        } else {
            this.errno = t instanceof IOException ? 3007 : (t instanceof ParseException ? 3000 : 3012);
        }
        this.writeHandler.fireDelayedSync(this.errno, this.error);
    }

    public void setExpectedResponse(int expectedRequestId) {
        this.expectedRequestId = expectedRequestId;
    }

    public void setFhandle(int fhandle) {
        this.fhandle = fhandle;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public void setOpenFile(boolean openFile) {
        this.isOpenFile = openFile;
    }

    public void setProtocolInfo(SecurityInfo protocolInfo) {
        this.protocolInfo = protocolInfo;
    }

    public void setPval(int pval) {
        this.pval = pval;
    }

    public void setResponseTimeout(long responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setSessionId(XrootdSessionIdentifier sessionId) {
        this.sessionId = sessionId;
    }

    public void setSigningPolicy(SigningPolicy signingPolicy) {
        this.signingPolicy = signingPolicy;
    }

    public void setTlsSessionInfo(TLSSessionInfo tlsSessionInfo) {
        this.tlsSessionInfo = tlsSessionInfo;
    }

    public void setWriteOffset(long writeOffset) {
        this.writeOffset = writeOffset;
    }

    public String toString() {
        return "(RUNNING " + this.isRunning + ")[info " + this.info + "](channelId " + (this.channelFuture == null ? "?" : this.channelFuture.channel().id()) + ")(streamId " + this.streamId + ")(userUrn " + this.userUrn + ")(protocol info " + this.protocolInfo + ")(pid " + this.pid + ")(uname " + this.uname + ")(fullpath " + this.getFullpath() + ")(expectedRequestId " + this.expectedRequestId + ")(pval " + this.pval + ")(flag " + this.flag + ")(sessionId " + this.sessionId + ")" + this.signingPolicy + ")(tls " + (this.tlsSessionInfo != null ? this.tlsSessionInfo.getClientTls() : "NONE") + "(cpsize " + this.cpsize + ")(cptype " + this.cptype + ")(fhandle " + this.fhandle + ")(isOpenFile " + this.isOpenFile + ")(writeOffset " + this.writeOffset + ")(errno " + this.errno + ")(error " + this.error + ")(redirects " + this.redirects + ")(last redirect " + new Date(this.timeOfFirstRedirect) + ")";
    }

    private TimeoutException getTimeoutException() {
        return new TimeoutException("No response from server after " + this.responseTimeout + " seconds.");
    }

    private void injectHandlers(ChannelPipeline pipeline, List<ChannelHandlerFactory> plugins, TpcSourceReadHandler readHandler) {
        pipeline.addLast("decoder", (ChannelHandler)new XrootdClientDecoder(this));
        pipeline.addLast("encoder", (ChannelHandler)new XrootdClientEncoder(this));
        TpcClientConnectHandler handler = new TpcClientConnectHandler();
        handler.setClient(this);
        pipeline.addLast("connect", (ChannelHandler)handler);
        readHandler.setClient(this);
        pipeline.addLast("read", (ChannelHandler)readHandler);
        for (ChannelHandlerFactory factory : plugins) {
            ChannelHandler authHandler = factory.createHandler();
            if (authHandler instanceof AbstractClientRequestHandler) {
                ((AbstractClientRequestHandler)authHandler).setClient(this);
            }
            this.authnHandlers.put(factory.getName(), authHandler);
        }
    }

    private void sendHandshakeRequest(ChannelHandlerContext ctx) {
        this.tlsSessionInfo.createClientSession(this.getInfo());
        LOGGER.debug("sendHandshakeRequest to {}, channel {}, stream {}.", new Object[]{this.info.getSrc(), ctx.channel().id(), this.streamId});
        ctx.writeAndFlush((Object)new OutboundHandshakeRequest(), ctx.newPromise()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }
}

