/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import org.dcache.xrootd.tpc.protocol.messages.XrootdOutboundRequest;

public abstract class AbstractXrootdOutboundRequest
implements XrootdOutboundRequest {
    protected final int streamId;
    protected final int requestId;

    protected AbstractXrootdOutboundRequest(int streamId, int requestId) {
        this.streamId = streamId;
        this.requestId = requestId;
    }

    @Override
    public int getStreamId() {
        return this.streamId;
    }

    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public void writeTo(ChannelHandlerContext ctx, ChannelPromise promise) {
        ByteBuf buffer = ctx.alloc().buffer(4 + this.getParamsLen());
        try {
            this.writeToBuffer(buffer);
        }
        catch (Error | RuntimeException t) {
            promise.setFailure(t);
            buffer.release();
            return;
        }
        ctx.write((Object)buffer, promise);
    }

    protected void writeToBuffer(ByteBuf buffer) {
        buffer.writeShort(this.streamId);
        buffer.writeShort(this.requestId);
        this.getParams(buffer);
    }

    protected abstract void getParams(ByteBuf var1);

    protected abstract int getParamsLen();
}

