/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.tls;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslContext;
import java.util.List;
import java.util.Properties;
import org.dcache.xrootd.plugins.ChannelHandlerFactory;

public abstract class SSLHandlerFactory
implements ChannelHandlerFactory {
    public static final String SERVER_TLS = "tls";
    public static final String CLIENT_TLS = "tls-client";
    protected SslContext sslContext;
    protected boolean startTls;
    protected String name;

    public static SSLHandlerFactory getHandlerFactory(String name, List<ChannelHandlerFactory> list) {
        return list.stream().filter(h -> name.equalsIgnoreCase(h.getName())).findFirst().orElse(null);
    }

    public void initialize(Properties properties, boolean startTls) throws Exception {
        this.startTls = startTls;
        this.name = startTls ? SERVER_TLS : CLIENT_TLS;
        this.sslContext = this.buildContext(properties);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "Creates and configures Netty SslHandler for the xrootd pipeline.";
    }

    @Override
    public ChannelHandler createHandler() {
        return this.sslContext.newHandler(ByteBufAllocator.DEFAULT);
    }

    protected abstract SslContext buildContext(Properties var1) throws Exception;
}

