/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.tls;

import com.google.common.base.Strings;
import java.util.Properties;
import org.dcache.xrootd.plugins.ChannelHandlerFactory;
import org.dcache.xrootd.plugins.ChannelHandlerProvider;
import org.dcache.xrootd.plugins.tls.SSLHandlerFactory;

public class TLSHandlerProvider
implements ChannelHandlerProvider {
    public static final String PLUGIN = "ssl-handler";
    public static final String CLIENT_PLUGIN = "ssl-client-handler";
    private static final String FACTORY_FQN = "xrootd.security.tls.handler-factory.class";

    @Override
    public ChannelHandlerFactory createFactory(String plugin, Properties properties) throws Exception {
        Class<?> clzz = this.getFactoryClass(properties);
        SSLHandlerFactory factory = null;
        if (plugin.equals(PLUGIN)) {
            factory = (SSLHandlerFactory)clzz.newInstance();
            factory.initialize(properties, true);
        } else if (plugin.equals(CLIENT_PLUGIN)) {
            factory = (SSLHandlerFactory)clzz.newInstance();
            factory.initialize(properties, false);
        }
        return factory;
    }

    private Class<?> getFactoryClass(Properties properties) throws ClassNotFoundException, ClassCastException {
        String handlerImpl = properties.getProperty(FACTORY_FQN);
        if (Strings.emptyToNull((String)handlerImpl) == null) {
            throw new ClassNotFoundException("tls handler factory has not been defined.");
        }
        Class<?> clzz = Thread.currentThread().getContextClassLoader().loadClass(handlerImpl);
        if (!SSLHandlerFactory.class.isAssignableFrom(clzz)) {
            String fatal = "The provided tls handler factory class must extend " + SSLHandlerFactory.class;
            throw new ClassCastException(fatal);
        }
        return clzz;
    }
}

