/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.util.FileStatus;

public class OpenResponse
extends AbstractXrootdResponse<OpenRequest> {
    private final int fileHandle;
    private final Integer cpsize;
    private final String cptype;
    private final FileStatus fs;

    public OpenResponse(OpenRequest request, int fileHandle, Integer cpsize, String cptype, FileStatus fs) {
        super(request, 0);
        this.fileHandle = fileHandle;
        this.cpsize = cpsize;
        this.cptype = cptype;
        this.fs = fs;
    }

    public int getFileHandle() {
        return this.fileHandle;
    }

    public FileStatus getFileStatus() {
        return this.fs;
    }

    @Override
    public int getDataLength() {
        return 4 + (this.cpsize != null && this.cptype != null || this.fs != null ? 8 : 0) + (this.fs != null ? this.fs.toString().length() + 1 : 0);
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        buffer.writeInt(this.fileHandle);
        if (this.cpsize != null && this.cptype != null) {
            buffer.writeInt(this.cpsize.intValue());
            int len = Math.min(this.cptype.length(), 4);
            buffer.writeBytes(this.cptype.getBytes(StandardCharsets.US_ASCII), 0, len);
            buffer.writeZero(4 - len);
        } else if (this.fs != null) {
            buffer.writeZero(8);
        }
        if (this.fs != null) {
            buffer.writeBytes(this.fs.toString().getBytes(StandardCharsets.US_ASCII));
            buffer.writeByte(0);
        }
    }

    public String toString() {
        return String.format("open-response[%d,%d,%s,%s]", this.fileHandle, this.cpsize, this.cptype, this.fs);
    }
}

