/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.dcache.xrootd.protocol.messages.AbstractXrootdRequest;
import org.dcache.xrootd.security.BufferDecrypter;

public class SigverRequest
extends AbstractXrootdRequest {
    public static final int kXR_SHA256 = 1;
    public static final int kXR_rsaKey = 128;
    public static final int kXR_HashMask = 15;
    public static final int SIGVER_VERSION = 0;
    private final long seqno;
    private final int expectrid;
    private final byte flags;
    private final byte crypto;
    private final byte version;
    private byte[] signature;

    public SigverRequest(ByteBuf buffer) {
        super(buffer, 3029);
        this.expectrid = buffer.getShort(4);
        this.version = buffer.getByte(6);
        this.flags = buffer.getByte(7);
        this.seqno = buffer.getLong(8);
        this.crypto = buffer.getByte(16);
        int dlen = buffer.getInt(20);
        this.signature = new byte[dlen];
        buffer.getBytes(24, this.signature);
    }

    public void decrypt(BufferDecrypter decrypter) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, InvalidKeyException {
        this.signature = decrypter.decrypt(this.signature);
    }

    public byte getCrypto() {
        return this.crypto;
    }

    public byte getVersion() {
        return this.version;
    }

    public boolean isSHA256() {
        return (this.crypto & 0xF) == 1;
    }

    public boolean isRSAKey() {
        return (this.crypto & 0x80) == 128;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int getExpectrid() {
        return this.expectrid;
    }

    public byte getFlags() {
        return this.flags;
    }

    public long getSeqno() {
        return this.seqno;
    }
}

