/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;

public class ZeroCopyReadResponse
implements XrootdResponse<ReadRequest> {
    private final ReadRequest request;
    private final FileChannel file;
    private final int count;

    public ZeroCopyReadResponse(ReadRequest request, FileChannel file) throws IOException {
        this.request = (ReadRequest)Preconditions.checkNotNull((Object)request);
        this.file = (FileChannel)Preconditions.checkNotNull((Object)file);
        this.count = (int)Math.min((long)request.bytesToRead(), file.size() - request.getReadOffset());
    }

    @Override
    public ReadRequest getRequest() {
        return this.request;
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public int getDataLength() {
        return this.count;
    }

    @Override
    public void writeTo(ChannelHandlerContext ctx, final ChannelPromise promise) {
        ByteBuf header = ctx.alloc().buffer(8);
        header.writeShort(this.request.getStreamId());
        header.writeShort(0);
        header.writeInt(this.count);
        ctx.write((Object)header).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                }
            }
        });
        ctx.write((Object)new OpenFileRegion(this.file, this.request.getReadOffset(), this.count)).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    promise.trySuccess();
                } else {
                    promise.tryFailure(future.cause());
                }
            }
        });
    }

    public String toString() {
        return String.format("zero-copy-read-response[offset=%d,bytes=%d]", this.request.getReadOffset(), this.count);
    }

    private static class OpenFileRegion
    extends DefaultFileRegion {
        public OpenFileRegion(FileChannel file, long position, long count) {
            super(file, position, count);
        }

        protected void deallocate() {
        }
    }
}

