/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import java.util.concurrent.TimeUnit;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.security.SecurityInfo;
import org.dcache.xrootd.tpc.AbstractClientRequestHandler;
import org.dcache.xrootd.tpc.XrootdTpcInfo;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundAttnResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundLoginResponse;

public abstract class AbstractClientAuthnHandler
extends AbstractClientRequestHandler {
    protected final String protocol;
    protected InboundLoginResponse loginResponse;

    protected AbstractClientAuthnHandler(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) {
        if (t instanceof RuntimeException) {
            super.exceptionCaught(ctx, t);
            return;
        }
        LOGGER.error("Unable to complete {} authentication to {}, channel {}, stream {}, session {}: {}.", new Object[]{this.protocol, this.client.getInfo().getSrc(), ctx.channel().id(), this.client.getStreamId(), this.client.getSessionId(), t.toString()});
        try {
            ctx.pipeline().remove((ChannelHandler)this);
            super.doOnLoginResponse(ctx, this.loginResponse);
        }
        catch (XrootdException e) {
            super.exceptionCaught(ctx, e);
        }
    }

    @Override
    protected void doOnAsynResponse(ChannelHandlerContext ctx, InboundAttnResponse response) throws XrootdException {
        switch (response.getRequestId()) {
            case 3000: {
                this.sendAuthenticationRequest(ctx);
                break;
            }
            default: {
                super.doOnAsynResponse(ctx, response);
            }
        }
    }

    @Override
    protected void doOnLoginResponse(ChannelHandlerContext ctx, InboundLoginResponse response) throws XrootdException {
        ChannelId id = ctx.channel().id();
        int streamId = this.client.getStreamId();
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        SecurityInfo sec = response.getInfo(this.protocol);
        if (sec == null) {
            String error = String.format("login to %s, channel %s, stream %s, session %s, %s handler was added to pipeline, but the protocol was notindicated by the server; this is a bug; please report to support@dcache.org.", tpcInfo.getSrc(), id, streamId, this.client.getSessionId(), this.protocol);
            throw new RuntimeException(error);
        }
        this.loginResponse = response;
        this.client.setProtocolInfo(sec);
        this.sendAuthenticationRequest(ctx);
    }

    @Override
    protected void doOnWaitResponse(ChannelHandlerContext ctx, AbstractXrootdInboundResponse response) throws XrootdException {
        switch (response.getRequestId()) {
            case 3000: {
                this.client.getExecutor().schedule(() -> {
                    try {
                        this.sendAuthenticationRequest(ctx);
                    }
                    catch (XrootdException e) {
                        this.exceptionCaught(ctx, e);
                    }
                }, (long)this.getWaitInSeconds(response), TimeUnit.SECONDS);
                break;
            }
            default: {
                super.doOnWaitResponse(ctx, response);
            }
        }
    }
}

