/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.core.XrootdRequestHandler;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.protocol.messages.ProtocolResponse;
import org.dcache.xrootd.protocol.messages.XrootdResponse;
import org.dcache.xrootd.security.SigningPolicy;
import org.dcache.xrootd.security.TLSSessionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdProtocolRequestHandler
extends XrootdRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XrootdProtocolRequestHandler.class);
    protected SigningPolicy signingPolicy;
    protected TLSSessionInfo tlsSessionInfo;

    public void setSigningPolicy(SigningPolicy signingPolicy) {
        this.signingPolicy = signingPolicy;
    }

    public void setTlsSessionInfo(TLSSessionInfo tlsSessionInfo) {
        this.tlsSessionInfo = tlsSessionInfo;
    }

    @Override
    protected XrootdResponse<ProtocolRequest> doOnProtocolRequest(ChannelHandlerContext ctx, ProtocolRequest msg) throws XrootdException {
        if (this.tlsSessionInfo == null) {
            throw new XrootdException(3012, "incomplete server information on protocol request");
        }
        LOGGER.debug("doOnProtocolRequest, version {}, expect {}, option {}.", new Object[]{msg.getVersion(), msg.getExpect(), msg.getOption()});
        this.tlsSessionInfo.setLocalTlsActivation(msg.getVersion(), msg.getOption(), msg.getExpect());
        if (this.tlsSessionInfo.serverUsesTls()) {
            this.signingPolicy = SigningPolicy.OFF;
            boolean isStarted = this.tlsSessionInfo.serverTransitionedToTLS(3006, ctx);
            LOGGER.debug("kXR_protocol, server has now transitioned to tls? {}.", (Object)isStarted);
        }
        LOGGER.debug("Sending protocol message with server flags {}, signing policy {}.", (Object)this.tlsSessionInfo.getLocalServerProtocolFlags(), (Object)this.signingPolicy);
        return new ProtocolResponse(msg, this.tlsSessionInfo.getLocalServerProtocolFlags().getFlags(), this.signingPolicy);
    }

    protected void enforceClientTlsIfDestinationRequiresItForTpc(Map<String, String> opaque) throws XrootdException {
        if (!opaque.containsKey("tpc.org") && !opaque.containsKey("tpc.src")) {
            LOGGER.debug("server is not TPC destination; no TLS TPC check.");
            return;
        }
        String spr = opaque.get("tpc.spr");
        String tpr = opaque.get("tpc.tpr");
        LOGGER.debug("server requires tls for tpc {}; incoming client is TLS capable {}; tpc.spr {}, tpc.tpr {}.", new Object[]{this.tlsSessionInfo.getLocalServerProtocolFlags().requiresTLSForTPC(), this.tlsSessionInfo.isIncomingClientTLSCapable(), spr, tpr});
        if (this.tlsSessionInfo.getLocalServerProtocolFlags().requiresTLSForTPC()) {
            if (!this.tlsSessionInfo.isIncomingClientTLSCapable()) {
                throw new XrootdException(3028, "Server accepts only secure connections for TPC.");
            }
            if (!"xroots".equals(tpr)) {
                throw new XrootdException(3028, "Wrong protocol expressed for TPC destination.");
            }
        }
    }
}

