/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import com.google.common.collect.Maps;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdAuthenticationHandler;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.core.XrootdRequestHandler;
import org.dcache.xrootd.core.XrootdSession;
import org.dcache.xrootd.core.XrootdSessionIdentifier;
import org.dcache.xrootd.core.XrootdSigverDecoder;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.authn.none.NoAuthenticationHandler;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.EndSessionRequest;
import org.dcache.xrootd.protocol.messages.LoginRequest;
import org.dcache.xrootd.protocol.messages.LoginResponse;
import org.dcache.xrootd.protocol.messages.OkResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.security.BufferDecrypter;
import org.dcache.xrootd.security.RequiresTLS;
import org.dcache.xrootd.security.SigningPolicy;
import org.dcache.xrootd.security.TLSSessionInfo;
import org.dcache.xrootd.util.UserNameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdSessionHandler
extends XrootdRequestHandler {
    public static final String SESSION_HANDLER = "sessionHandler";
    private static final Logger LOGGER = LoggerFactory.getLogger(XrootdSessionHandler.class);
    private static final ConcurrentMap<XrootdSessionIdentifier, XrootdSession> SESSIONS = Maps.newConcurrentMap();
    private static final XrootdSessionIdentifier CURRENT_SESSION_PLACEHOLDER = new XrootdSessionIdentifier(new byte[16]);
    private final AtomicBoolean inProgress = new AtomicBoolean(false);
    private final XrootdSessionIdentifier sessionId = new XrootdSessionIdentifier();
    private final Map<String, XrootdAuthenticationHandler> handlerMap = new LinkedHashMap<String, XrootdAuthenticationHandler>();
    private XrootdSession session;
    private TLSSessionInfo tlsSessionInfo;
    private SigningPolicy signingPolicy;
    private State state = State.NO_LOGIN;
    private XrootdAuthenticationHandler currentHandler;
    private String currentProtocol;

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        SESSIONS.remove(this.sessionId);
        super.channelInactive(ctx);
    }

    public void add(XrootdAuthenticationHandler handler) {
        this.handlerMap.put(handler.getProtocol(), handler);
    }

    public void setSubject(Subject subject) {
        this.session.setSubject(subject);
    }

    @Override
    protected Object getResponse(ChannelHandlerContext ctx, XrootdRequest req) throws Exception {
        switch (req.getRequestId()) {
            case 3007: {
                LOGGER.debug("XrootdSessionHandler.getResponse: Request kXR_login");
                return this.doOnLogin(ctx, (LoginRequest)req);
            }
            case 3000: {
                LOGGER.debug("XrootdSessionHandler.getResponse: Request kXR_auth");
                if (this.inProgress.compareAndSet(false, true)) {
                    try {
                        switch (this.state) {
                            case NO_LOGIN: {
                                LOGGER.debug("Request kXR_auth isInProgress: NO LOGIN");
                                throw new XrootdException(3010, "Login required");
                            }
                            case AUTH: {
                                LOGGER.debug("Request kXR_auth isInProgress: AUTH");
                                throw new XrootdException(3006, "Already authenticated");
                            }
                        }
                        req.setSession(this.session);
                        this.handleAuthentication(ctx, (AuthenticationRequest)req);
                        break;
                    }
                    finally {
                        this.inProgress.set(false);
                    }
                }
                throw new XrootdException(3020, "Login in progress");
            }
            case 3023: {
                LOGGER.debug("XrootdSessionHandler.getResponse: Request kXR_endsess");
                switch (this.state) {
                    case NO_LOGIN: {
                        LOGGER.debug("Request kXR_endsess NO_LOGIN");
                        throw new XrootdException(3010, "Login required");
                    }
                    case NO_AUTH: {
                        LOGGER.debug("Request kXR_endsess NO_AUTH");
                        throw new XrootdException(3010, "Authentication required");
                    }
                }
                return this.doOnEndSession(ctx, (EndSessionRequest)req);
            }
            case 3006: {
                LOGGER.debug("XrootdSessionHandler.getResponse: Request kXR_protocol");
                ctx.fireChannelRead((Object)req);
                break;
            }
            case 3024: {
                LOGGER.debug("XrootdSessionHandler.getResponse: Request kXR_bind");
                if (this.tlsSessionInfo != null && this.tlsSessionInfo.serverUsesTls()) {
                    boolean isStarted = this.tlsSessionInfo.serverTransitionedToTLS(3024, ctx);
                    LOGGER.debug("kXR_bind, server has now transitioned to tls? {}.", (Object)isStarted);
                }
                ctx.fireChannelRead((Object)req);
                break;
            }
            case 3011: {
                LOGGER.debug("XrootdSessionHandler.getResponse: Request kXR_ping");
                if (!this.isLoginStarted()) {
                    LOGGER.debug("Request kXR_ping: NO LOGIN");
                    throw new XrootdException(3010, "Login required");
                }
                req.setSession(this.session);
                ctx.fireChannelRead((Object)req);
                break;
            }
            default: {
                LOGGER.debug("XrootdSessionHandler.getResponse: Request {}", (Object)req.getRequestId());
                switch (this.state) {
                    case NO_LOGIN: {
                        LOGGER.debug("{}, NO LOGIN", (Object)req);
                        throw new XrootdException(3010, "Login required");
                    }
                    case NO_AUTH: {
                        LOGGER.debug("{}, NO_AUTH", (Object)req);
                        throw new XrootdException(3010, "Authentication required");
                    }
                }
                req.setSession(this.session);
                ctx.fireChannelRead((Object)req);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LoginResponse doOnLogin(ChannelHandlerContext ctx, LoginRequest request) throws XrootdException {
        if (this.inProgress.compareAndSet(false, true)) {
            try {
                request.setUserName(UserNameUtils.checkUsernameValid(request.getUserName()));
                this.session = new XrootdSession(this.sessionId, ctx.channel(), request);
                request.setSession(this.session);
                LoginResponse response = new LoginResponse(request, this.sessionId, this.protocolString());
                SESSIONS.put(this.sessionId, this.session);
                this.setLoginStarted();
                LoginResponse loginResponse = response;
                return loginResponse;
            }
            finally {
                this.inProgress.set(false);
            }
        }
        throw new XrootdException(3020, "Login in progress");
    }

    @Override
    protected Object doOnEndSession(ChannelHandlerContext ctx, EndSessionRequest request) throws XrootdException {
        XrootdSessionIdentifier id = request.getSessionId();
        if (id.equals(CURRENT_SESSION_PLACEHOLDER)) {
            ctx.channel().close();
            return new OkResponse<EndSessionRequest>(request);
        }
        XrootdSession session = (XrootdSession)SESSIONS.get(id);
        if (session != null) {
            if (!session.hasOwner(this.session.getSubject())) {
                throw new XrootdException(3010, "not session owner");
            }
            session.getChannel().close();
        }
        return new OkResponse<EndSessionRequest>(request);
    }

    private void handleAuthentication(ChannelHandlerContext ctx, AuthenticationRequest request) throws XrootdException {
        if (this.currentHandler == null) {
            this.currentProtocol = request.getCredType();
            this.currentHandler = this.handlerMap.get(this.currentProtocol);
            if (this.currentHandler == null) {
                throw new XrootdException(3010, "server does not support " + this.currentProtocol);
            }
            if (this.currentHandler instanceof RequiresTLS && !TLSSessionInfo.isTLSOn(ctx)) {
                throw new XrootdException(3013, "TLS is required for " + this.currentProtocol);
            }
            ctx.pipeline().addAfter(SESSION_HANDLER, this.currentProtocol, (ChannelHandler)this.currentHandler);
        }
        ctx.fireChannelRead((Object)request);
    }

    public boolean isLoginStarted() {
        return this.state != State.NO_LOGIN;
    }

    public void setLoginStarted() {
        this.state = State.NO_AUTH;
    }

    public void setAuthSucceeded(ChannelHandlerContext ctx) throws XrootdException {
        this.state = State.AUTH;
        if (this.tlsSessionInfo != null && this.tlsSessionInfo.serverUsesTls()) {
            boolean isStarted = this.tlsSessionInfo.serverTransitionedToTLS(3000, ctx);
            LOGGER.debug("kXR_auth, server has now transitioned to tls? {}.", (Object)isStarted);
        } else {
            AuthenticationHandler authHandler = this.currentHandler.getHandler();
            if (!(authHandler instanceof NoAuthenticationHandler) && !TLSSessionInfo.isTLSOn(ctx) && this.signingPolicy.isSigningOn()) {
                BufferDecrypter decrypter = authHandler.getDecrypter();
                ctx.pipeline().addAfter("decoder", "sigverDecoder", (ChannelHandler)new XrootdSigverDecoder(this.signingPolicy, decrypter));
                ctx.pipeline().remove("decoder");
                LOGGER.debug("switched decoder to sigverDecoder, decrypter {}.", (Object)decrypter);
            }
        }
        ctx.pipeline().remove((ChannelHandler)this.currentHandler);
        this.currentHandler = null;
        this.currentProtocol = null;
    }

    public void setAuthFailed(ChannelHandlerContext ctx) {
        this.state = State.NO_AUTH;
        ctx.pipeline().remove((ChannelHandler)this.currentHandler);
        this.currentHandler = null;
        this.currentProtocol = null;
    }

    public void setSigningPolicy(SigningPolicy signingPolicy) {
        this.signingPolicy = signingPolicy;
    }

    public void setTlsSessionInfo(TLSSessionInfo tlsSessionInfo) {
        this.tlsSessionInfo = tlsSessionInfo;
    }

    private String protocolString() {
        String protocols = this.handlerMap.values().stream().map(h -> h.getHandler()).filter(h -> this.tlsSessionInfo.serverUsesTls() || !h.getProtocolName().equals("ztn")).map(AuthenticationHandler::getProtocol).collect(Collectors.joining());
        LOGGER.debug("protocols: {}.", (Object)protocols);
        return protocols;
    }

    private static enum State {
        NO_LOGIN,
        NO_AUTH,
        AUTH;

    }
}

