/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.protocol.messages.AbstractXrootdRequest;

public class LoginRequest
extends AbstractXrootdRequest {
    private final short role;
    private final short capver;
    private final int pid;
    private final String token;
    private String username;

    public LoginRequest(ByteBuf buffer) {
        super(buffer, 3007);
        int pos = buffer.indexOf(8, 16, (byte)0);
        this.username = pos > -1 ? buffer.toString(8, pos - 8, StandardCharsets.US_ASCII) : buffer.toString(8, 8, StandardCharsets.US_ASCII);
        this.pid = buffer.getInt(4);
        this.capver = buffer.getUnsignedByte(18);
        this.role = buffer.getUnsignedByte(19);
        int tlen = buffer.getInt(20);
        this.token = buffer.toString(24, tlen, StandardCharsets.US_ASCII);
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public boolean supportsAsyn() {
        return (this.capver & 0x80) == 128;
    }

    public int getClientProtocolVersion() {
        return this.capver & 0x3F;
    }

    public boolean isAdmin() {
        return this.role == 1;
    }

    public int getPID() {
        return this.pid;
    }

    public String getToken() {
        return this.token;
    }

    public String toString() {
        return "login[" + this.username + "," + this.pid + "," + this.capver + "," + this.role + "," + this.token + "]";
    }
}

