/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.security.SigningPolicy;

public class ProtocolResponse
extends AbstractXrootdResponse<ProtocolRequest> {
    private static final byte RESERVED = 0;
    private static final byte SECVER = 0;
    private final int flags;
    private SigningPolicy signingPolicy;

    public ProtocolResponse(ProtocolRequest request, int flags) {
        this(request, flags, new SigningPolicy());
    }

    public ProtocolResponse(ProtocolRequest request, int flags, SigningPolicy signingPolicy) {
        super(request, 0);
        this.flags = flags;
        this.signingPolicy = signingPolicy;
    }

    public int getFlags() {
        return this.flags;
    }

    public SigningPolicy getSigningPolicy() {
        return this.signingPolicy;
    }

    @Override
    public int getDataLength() {
        return this.shouldReturnSecOpts() && this.signingPolicy.isSigningOn() ? 14 : 8;
    }

    public String toString() {
        return String.format("protocol-response[%d][%s]", this.flags, this.signingPolicy);
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        buffer.writeInt(1280);
        buffer.writeInt(this.flags);
        if (this.getDataLength() == 14) {
            buffer.writeByte(83);
            buffer.writeByte(0);
            buffer.writeByte(0);
            this.signingPolicy.writeBytes(buffer);
        }
    }

    private boolean shouldReturnSecOpts() {
        return ((ProtocolRequest)this.request).getVersion() >= 784 && (((ProtocolRequest)this.request).getOption() & 1) == 1;
    }
}

