/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectResponse<R extends XrootdRequest>
extends AbstractXrootdResponse<R> {
    private static final Logger _logger = LoggerFactory.getLogger(RedirectResponse.class);
    private final String host;
    private final int port;
    private final String opaque;
    private final String token;

    public RedirectResponse(R request, String host, int port) {
        this(request, host, port, "", "");
    }

    public RedirectResponse(R request, String host, int port, String opaque, String token) {
        super(request, 4004);
        this.host = host;
        this.port = port;
        this.opaque = opaque;
        this.token = token;
        _logger.info("Sending the following host information to the client: {}", (Object)host);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public int getDataLength() {
        return 4 + this.host.length() + (!this.opaque.isEmpty() || !this.token.isEmpty() ? 1 + this.opaque.length() : 0) + (!this.token.isEmpty() ? 1 + this.token.length() : 0);
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        buffer.writeInt(this.port);
        buffer.writeBytes(this.host.getBytes(StandardCharsets.US_ASCII));
        if (!this.opaque.isEmpty() || !this.token.isEmpty()) {
            buffer.writeByte(63);
            buffer.writeBytes(this.opaque.getBytes(StandardCharsets.US_ASCII));
        }
        if (!this.token.isEmpty()) {
            buffer.writeByte(63);
            buffer.writeBytes(this.token.getBytes(StandardCharsets.US_ASCII));
        }
    }

    public String toString() {
        return String.format("redirect[%s:%d,%s,%s]", this.host, this.port, this.opaque, this.token);
    }
}

