/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdOutboundRequest;

public class OutboundChecksumRequest
extends AbstractXrootdOutboundRequest {
    private static final byte[] RESERVED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private String path;

    public OutboundChecksumRequest(int streamId, String path) {
        super(streamId, 3001);
        this.path = (String)Preconditions.checkNotNull((Object)path);
    }

    @Override
    protected void getParams(ByteBuf buffer) {
        buffer.writeShort(3);
        buffer.writeBytes(RESERVED);
        buffer.writeInt(this.path.length());
        buffer.writeBytes(this.path.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    protected int getParamsLen() {
        return 20 + this.path.length();
    }
}

