/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.ByteToMessageDecoder;
import org.dcache.xrootd.protocol.XrootdProtocol;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.CloseRequest;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.EndSessionRequest;
import org.dcache.xrootd.protocol.messages.FattrRequest;
import org.dcache.xrootd.protocol.messages.LocateRequest;
import org.dcache.xrootd.protocol.messages.LoginRequest;
import org.dcache.xrootd.protocol.messages.MkDirRequest;
import org.dcache.xrootd.protocol.messages.MvRequest;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.protocol.messages.PrepareRequest;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.protocol.messages.QueryRequest;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.protocol.messages.RmDirRequest;
import org.dcache.xrootd.protocol.messages.RmRequest;
import org.dcache.xrootd.protocol.messages.SetRequest;
import org.dcache.xrootd.protocol.messages.SigverRequest;
import org.dcache.xrootd.protocol.messages.StatRequest;
import org.dcache.xrootd.protocol.messages.StatxRequest;
import org.dcache.xrootd.protocol.messages.SyncRequest;
import org.dcache.xrootd.protocol.messages.UnknownRequest;
import org.dcache.xrootd.protocol.messages.WriteRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXrootdDecoder
extends ByteToMessageDecoder {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractXrootdDecoder.class);
    private int maxWriteBufferSize = Integer.MAX_VALUE;
    private WriteRequest lastWrite;
    private int remainingDataLength;

    public int getMaxWriteBufferSize() {
        return this.maxWriteBufferSize;
    }

    public void setMaxWriteBufferSize(int maxFrameSize) {
        this.maxWriteBufferSize = maxFrameSize;
    }

    protected XrootdRequest getRequest(ByteBuf frame) {
        if (this.lastWrite != null) {
            return this.getWriteRequest(frame);
        }
        int requestId = frame.getUnsignedShort(2);
        switch (requestId) {
            case 3029: {
                return new SigverRequest(frame);
            }
            case 3007: {
                return new LoginRequest(frame);
            }
            case 3021: {
                return new PrepareRequest(frame);
            }
            case 3010: {
                return new OpenRequest(frame);
            }
            case 3017: {
                return new StatRequest(frame);
            }
            case 3022: {
                return new StatxRequest(frame);
            }
            case 3013: {
                return new ReadRequest(frame);
            }
            case 3025: {
                return new ReadVRequest(frame);
            }
            case 3019: {
                return this.getWriteRequest(frame);
            }
            case 3016: {
                return new SyncRequest(frame);
            }
            case 3003: {
                return new CloseRequest(frame);
            }
            case 3006: {
                return new ProtocolRequest(frame);
            }
            case 3014: {
                return new RmRequest(frame);
            }
            case 3015: {
                return new RmDirRequest(frame);
            }
            case 3008: {
                return new MkDirRequest(frame);
            }
            case 3009: {
                return new MvRequest(frame);
            }
            case 3004: {
                return new DirListRequest(frame);
            }
            case 3000: {
                return new AuthenticationRequest(frame);
            }
            case 3023: {
                return new EndSessionRequest(frame);
            }
            case 3027: {
                return new LocateRequest(frame);
            }
            case 3001: {
                return new QueryRequest(frame);
            }
            case 3018: {
                return new SetRequest(frame);
            }
            case 3020: {
                return new FattrRequest(frame);
            }
        }
        return new UnknownRequest(frame);
    }

    protected int verifyMessageLength(ByteBuf in) {
        int readable = in.readableBytes();
        if (this.remainingDataLength > 0) {
            int desiredChunk = Math.min(this.maxWriteBufferSize, this.remainingDataLength);
            LOGGER.trace("verifyMessageLength: remaining {}, desired {}, readable {}", new Object[]{this.remainingDataLength, desiredChunk, readable});
            if (readable < desiredChunk) {
                return 0;
            }
            this.remainingDataLength -= desiredChunk;
            return desiredChunk;
        }
        if (readable < 24) {
            return 0;
        }
        int pos = in.readerIndex();
        int requestId = in.getUnsignedShort(pos + 2);
        int frameLength = in.getInt(pos + 20);
        if (frameLength < 0) {
            return -1;
        }
        LOGGER.trace("verifyMessageLength: {}, frame length: {}", (Object)XrootdProtocol.getClientRequest(requestId), (Object)frameLength);
        int length = 24 + Math.min(frameLength, this.maxWriteBufferSize);
        if (readable < length) {
            return 0;
        }
        if (frameLength > this.maxWriteBufferSize) {
            if (requestId != 3019) {
                return -1;
            }
            this.remainingDataLength = frameLength - this.maxWriteBufferSize;
            LOGGER.trace("verifyMessageLength: write request data length: {}", (Object)frameLength);
        } else {
            this.remainingDataLength = 0;
        }
        return length;
    }

    private WriteRequest getWriteRequest(ByteBuf frame) {
        ByteBuf data;
        int length;
        long offset;
        int fhandle;
        int streamId;
        if (this.lastWrite == null) {
            streamId = frame.getUnsignedShort(0);
            fhandle = frame.getInt(4);
            offset = frame.getLong(8);
            length = Math.min(frame.getInt(20), this.maxWriteBufferSize);
            data = frame.retainedSlice(24, length);
        } else {
            streamId = this.lastWrite.getStreamId();
            fhandle = this.lastWrite.getFileHandle();
            offset = this.lastWrite.getWriteOffset() + (long)this.lastWrite.getDataLength();
            length = frame.readableBytes();
            data = frame.retainedSlice(0, length);
        }
        WriteRequest request = new WriteRequest(streamId, fhandle, offset, length, data, this.remainingDataLength);
        LOGGER.trace("getWriteRequest, fhandle {}, offset {}, data length {}; remaining: {}.", new Object[]{fhandle, offset, length, this.remainingDataLength});
        this.lastWrite = this.remainingDataLength > 0 ? request : null;
        return request;
    }
}

