/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.core.XrootdRequestHandler;
import org.dcache.xrootd.core.XrootdSessionHandler;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.ProxyDelegationClient;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdAuthenticationHandler
extends XrootdRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XrootdAuthenticationHandler.class);
    private final String protocol;
    private final ProxyDelegationClient proxyDelegationClient;
    private final AuthenticationHandler authenticationHandler;
    private XrootdSessionHandler sessionHandler;

    public XrootdAuthenticationHandler(String protocol, AuthenticationFactory authenticationFactory, ProxyDelegationClient proxyDelegationClient) {
        this.protocol = protocol;
        this.proxyDelegationClient = proxyDelegationClient;
        this.authenticationHandler = authenticationFactory.createHandler(proxyDelegationClient);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public AuthenticationHandler getHandler() {
        return this.authenticationHandler;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.proxyDelegationClient != null) {
            this.proxyDelegationClient.close();
        }
    }

    public void setSessionHandler(XrootdSessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    @Override
    protected Object doOnAuthentication(ChannelHandlerContext context, AuthenticationRequest request) throws XrootdException {
        XrootdResponse<AuthenticationRequest> response = this.authenticationHandler.authenticate(request);
        if (this.authenticationHandler.isCompleted()) {
            LOGGER.debug("doOnAuthentication, response {}, is completed.", response);
            this.authenticated(context, this.authenticationHandler.getSubject());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getResponse(ChannelHandlerContext ctx, XrootdRequest req) {
        switch (req.getRequestId()) {
            case 3000: {
                try {
                    Object object = this.doOnAuthentication(ctx, (AuthenticationRequest)req);
                    return object;
                }
                catch (XrootdException e) {
                    LOGGER.debug("authenticated, login failed {}: {}.", (Object)e.getError(), (Object)e.getMessage());
                    this.sessionHandler.setAuthFailed(ctx);
                    this.respond(ctx, this.withError(ctx, req, e.getError(), e.getMessage()));
                    Object var4_6 = null;
                    return var4_6;
                }
                finally {
                    ReferenceCountUtil.release((Object)req);
                }
            }
        }
        try {
            ctx.fireChannelRead((Object)req);
            Object var3_5 = null;
            return var3_5;
        }
        finally {
            ReferenceCountUtil.release((Object)req);
        }
    }

    protected Subject login(ChannelHandlerContext context, Subject subject) throws XrootdException {
        return subject;
    }

    private void authenticated(ChannelHandlerContext context, Subject subject) throws XrootdException {
        this.sessionHandler.setSubject(this.login(context, subject));
        this.sessionHandler.setAuthSucceeded(context);
        LOGGER.debug("authenticated, set subject on session for login.");
    }
}

