/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.dcache.xrootd.core.AbstractXrootdDecoder;
import org.dcache.xrootd.util.ByteBuffersProvider;

public class XrootdDecoder
extends AbstractXrootdDecoder {
    public static String readAscii(ByteBuf buffer, int length) {
        String ascii = buffer.toString(buffer.readerIndex(), length, StandardCharsets.US_ASCII).trim();
        buffer.readerIndex(buffer.readerIndex() + length);
        return ascii;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        int length = this.verifyMessageLength(in);
        if (length < 0) {
            ctx.channel().close();
            return;
        }
        if (length == 0) {
            return;
        }
        out.add(this.getRequest(in.readSlice(length)));
        if (LOGGER.isTraceEnabled()) {
            ByteBuffersProvider.logMetrics("decode", ctx.alloc(), LOGGER, "TRACE");
        }
    }
}

