/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.protocol.XrootdProtocol;
import org.dcache.xrootd.protocol.messages.OkResponse;
import org.dcache.xrootd.protocol.messages.WriteRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class XrootdEncoder
extends ChannelOutboundHandlerAdapter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(XrootdEncoder.class);

    public static void writeZeroPad(String data, ByteBuf out, int length) {
        byte[] bytes = data.getBytes(StandardCharsets.US_ASCII);
        int len = Math.min(bytes.length, length);
        out.writeBytes(bytes, 0, len);
        if (len < length) {
            out.writeZero(length - len);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof XrootdResponse) {
            Object request;
            XrootdResponse response = (XrootdResponse)msg;
            if (response instanceof OkResponse && (request = response.getRequest()) instanceof WriteRequest && !((WriteRequest)request).isComplete()) {
                LOGGER.trace("incomplete write request of length {}; skipping response.", (Object)((WriteRequest)request).getDataLength());
                return;
            }
            LOGGER.trace("sending response: {} for {}.", (Object)response.getStatus(), (Object)XrootdProtocol.getClientRequest(response.getRequest().getRequestId()));
            response.writeTo(ctx, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }
}

