/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import com.google.common.net.InetAddresses;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.CloseRequest;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.EndSessionRequest;
import org.dcache.xrootd.protocol.messages.ErrorResponse;
import org.dcache.xrootd.protocol.messages.FattrRequest;
import org.dcache.xrootd.protocol.messages.LocateRequest;
import org.dcache.xrootd.protocol.messages.LoginRequest;
import org.dcache.xrootd.protocol.messages.MkDirRequest;
import org.dcache.xrootd.protocol.messages.MvRequest;
import org.dcache.xrootd.protocol.messages.OkResponse;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.protocol.messages.PrepareRequest;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.protocol.messages.QueryRequest;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.protocol.messages.RmDirRequest;
import org.dcache.xrootd.protocol.messages.RmRequest;
import org.dcache.xrootd.protocol.messages.SetRequest;
import org.dcache.xrootd.protocol.messages.StatRequest;
import org.dcache.xrootd.protocol.messages.StatxRequest;
import org.dcache.xrootd.protocol.messages.SyncRequest;
import org.dcache.xrootd.protocol.messages.WriteRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdRequestHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger _log = LoggerFactory.getLogger(XrootdRequestHandler.class);
    private boolean _isHealthCheck;
    private InetSocketAddress _destinationAddress;
    private InetSocketAddress _sourceAddress;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this._destinationAddress = (InetSocketAddress)ctx.channel().localAddress();
        this._sourceAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof XrootdRequest) {
            this.requestReceived(ctx, (XrootdRequest)msg);
        } else if (msg instanceof HAProxyMessage) {
            HAProxyMessage proxyMessage = (HAProxyMessage)msg;
            switch (proxyMessage.command()) {
                case LOCAL: {
                    this._isHealthCheck = true;
                    break;
                }
                case PROXY: {
                    String sourceAddress = proxyMessage.sourceAddress();
                    String destinationAddress = proxyMessage.destinationAddress();
                    InetSocketAddress localAddress = (InetSocketAddress)ctx.channel().localAddress();
                    if (proxyMessage.proxiedProtocol() != HAProxyProxiedProtocol.TCP4 && proxyMessage.proxiedProtocol() != HAProxyProxiedProtocol.TCP6) break;
                    if (Objects.equals(destinationAddress, localAddress.getAddress().getHostAddress())) {
                        this._isHealthCheck = true;
                        break;
                    }
                    this._destinationAddress = new InetSocketAddress(InetAddresses.forString((String)destinationAddress), proxyMessage.destinationPort());
                    this._sourceAddress = new InetSocketAddress(InetAddresses.forString((String)sourceAddress), proxyMessage.sourcePort());
                }
            }
            ctx.fireChannelRead(msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            if (!((SslHandshakeCompletionEvent)evt).isSuccess()) {
                Throwable t = ((SslHandshakeCompletionEvent)evt).cause();
                _log.error("TLS handshake failed: {}.", (Object)(t == null ? "no cause reported" : t.toString()));
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestReceived(ChannelHandlerContext ctx, XrootdRequest req) {
        try {
            Object response = this.getResponse(ctx, req);
            if (response != null) {
                this.respond(ctx, response);
            } else {
                req = null;
            }
        }
        catch (XrootdException e) {
            this.respond(ctx, this.withError(ctx, req, e.getError(), e.getMessage()));
        }
        catch (Exception e) {
            _log.error("xrootd server error while processing " + req + " (please report this to support@dcache.org)", (Throwable)e);
            this.respond(ctx, this.withError(ctx, req, 3012, String.format("Internal server error (%s)", e.getMessage())));
        }
        finally {
            ReferenceCountUtil.release((Object)req);
        }
    }

    protected Object getResponse(ChannelHandlerContext ctx, XrootdRequest req) throws Exception {
        switch (req.getRequestId()) {
            case 3000: {
                return this.doOnAuthentication(ctx, (AuthenticationRequest)req);
            }
            case 3007: {
                return this.doOnLogin(ctx, (LoginRequest)req);
            }
            case 3010: {
                return this.doOnOpen(ctx, (OpenRequest)req);
            }
            case 3017: {
                return this.doOnStat(ctx, (StatRequest)req);
            }
            case 3022: {
                return this.doOnStatx(ctx, (StatxRequest)req);
            }
            case 3013: {
                return this.doOnRead(ctx, (ReadRequest)req);
            }
            case 3025: {
                return this.doOnReadV(ctx, (ReadVRequest)req);
            }
            case 3019: {
                return this.doOnWrite(ctx, (WriteRequest)req);
            }
            case 3016: {
                return this.doOnSync(ctx, (SyncRequest)req);
            }
            case 3003: {
                return this.doOnClose(ctx, (CloseRequest)req);
            }
            case 3006: {
                return this.doOnProtocolRequest(ctx, (ProtocolRequest)req);
            }
            case 3014: {
                return this.doOnRm(ctx, (RmRequest)req);
            }
            case 3015: {
                return this.doOnRmDir(ctx, (RmDirRequest)req);
            }
            case 3008: {
                return this.doOnMkDir(ctx, (MkDirRequest)req);
            }
            case 3009: {
                return this.doOnMv(ctx, (MvRequest)req);
            }
            case 3004: {
                return this.doOnDirList(ctx, (DirListRequest)req);
            }
            case 3021: {
                return this.doOnPrepare(ctx, (PrepareRequest)req);
            }
            case 3027: {
                return this.doOnLocate(ctx, (LocateRequest)req);
            }
            case 3001: {
                return this.doOnQuery(ctx, (QueryRequest)req);
            }
            case 3018: {
                return this.doOnSet(ctx, (SetRequest)req);
            }
            case 3023: {
                return this.doOnEndSession(ctx, (EndSessionRequest)req);
            }
            case 3020: {
                return this.doOnFattr(ctx, (FattrRequest)req);
            }
        }
        return this.unsupported(ctx, req);
    }

    protected <T extends XrootdRequest> OkResponse<T> withOk(T req) {
        return new OkResponse<T>(req);
    }

    protected <T extends XrootdRequest> ErrorResponse<T> withError(ChannelHandlerContext ctx, T req, int errorCode, String errMsg) {
        return new ErrorResponse<T>(ctx, req, errorCode, errMsg);
    }

    protected ChannelFuture respond(ChannelHandlerContext ctx, Object response) {
        return ctx.writeAndFlush(response).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    protected <T extends XrootdRequest> XrootdResponse<T> unsupported(ChannelHandlerContext ctx, T msg) throws XrootdException {
        _log.warn("Unsupported request: " + msg);
        throw new XrootdException(3013, "Request " + msg.getRequestId() + " not supported");
    }

    protected Object doOnLogin(ChannelHandlerContext ctx, LoginRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnAuthentication(ChannelHandlerContext ctx, AuthenticationRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnOpen(ChannelHandlerContext ctx, OpenRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnFattr(ChannelHandlerContext ctx, FattrRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnStat(ChannelHandlerContext ctx, StatRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnStatx(ChannelHandlerContext ctx, StatxRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnRead(ChannelHandlerContext ctx, ReadRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnReadV(ChannelHandlerContext ctx, ReadVRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnWrite(ChannelHandlerContext ctx, WriteRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnSync(ChannelHandlerContext ctx, SyncRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnClose(ChannelHandlerContext ctx, CloseRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnProtocolRequest(ChannelHandlerContext ctx, ProtocolRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnRm(ChannelHandlerContext ctx, RmRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnRmDir(ChannelHandlerContext ctx, RmDirRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnMkDir(ChannelHandlerContext ctx, MkDirRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnMv(ChannelHandlerContext ctx, MvRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnDirList(ChannelHandlerContext ctx, DirListRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnPrepare(ChannelHandlerContext ctx, PrepareRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnLocate(ChannelHandlerContext ctx, LocateRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnQuery(ChannelHandlerContext ctx, QueryRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnSet(ChannelHandlerContext ctx, SetRequest request) throws XrootdException {
        return this.unsupported(ctx, request);
    }

    protected Object doOnEndSession(ChannelHandlerContext ctx, EndSessionRequest request) throws XrootdException {
        return this.unsupported(ctx, request);
    }

    protected InetSocketAddress getDestinationAddress() {
        return this._destinationAddress;
    }

    protected InetSocketAddress getSourceAddress() {
        return this._sourceAddress;
    }

    protected boolean isHealthCheck() {
        return this._isHealthCheck;
    }
}

