/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdSession;
import org.dcache.xrootd.protocol.messages.XrootdRequest;

public class AbstractXrootdRequest
implements XrootdRequest {
    protected final int streamId;
    protected final int requestId;
    protected XrootdSession session;

    public AbstractXrootdRequest(ByteBuf buffer, int requestId) {
        this(buffer);
        Preconditions.checkState((this.requestId == requestId ? 1 : 0) != 0);
    }

    public AbstractXrootdRequest(ByteBuf buffer) {
        this.streamId = buffer.getUnsignedShort(0);
        this.requestId = buffer.getUnsignedShort(2);
    }

    public AbstractXrootdRequest(int streamId, int requestId) {
        this.streamId = streamId;
        this.requestId = requestId;
    }

    @Override
    public int getStreamId() {
        return this.streamId;
    }

    @Override
    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public void setSession(XrootdSession session) {
        this.session = session;
    }

    @Override
    public XrootdSession getSession() {
        return this.session;
    }

    @Override
    public Subject getSubject() {
        return this.session == null ? null : this.session.getSubject();
    }
}

