/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.DirListStatResponse;
import org.dcache.xrootd.util.FileStatus;

public class DirListResponse
extends AbstractXrootdResponse<DirListRequest> {
    protected final Iterable<String> names;

    public DirListResponse(DirListRequest request, int statusCode, Iterable<String> names) {
        super(request, statusCode);
        this.names = names;
    }

    public DirListResponse(DirListRequest request, Iterable<String> names) {
        this(request, 0, names);
    }

    public Iterable<String> getNames() {
        return this.names;
    }

    @Override
    public int getDataLength() {
        int length = 0;
        for (String name : this.names) {
            length += name.length() + 1;
        }
        return length;
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        Iterator<String> i = this.names.iterator();
        if (i.hasNext()) {
            buffer.writeBytes(i.next().getBytes(StandardCharsets.US_ASCII));
            while (i.hasNext()) {
                buffer.writeByte(10);
                buffer.writeBytes(i.next().getBytes(StandardCharsets.US_ASCII));
            }
            if (this.stat == 4000) {
                buffer.writeByte(10);
            } else {
                buffer.writeByte(0);
            }
        }
    }

    public static Builder builder(DirListRequest request) {
        return request.isDirectoryStat() ? new StatBuilder(request) : new SimpleBuilder(request);
    }

    private static class StatBuilder
    implements Builder {
        private final DirListRequest request;
        private List<String> names = new ArrayList<String>();
        private List<FileStatus> fileStatus = new ArrayList<FileStatus>();
        private boolean isFirst = true;

        public StatBuilder(DirListRequest request) {
            this.request = request;
        }

        @Override
        public void add(String name) {
            this.names.add(name);
            this.fileStatus.add(new FileStatus(0L, 0L, 0, 0L));
        }

        @Override
        public void add(String name, FileStatus status) {
            this.names.add(name);
            this.fileStatus.add(status);
        }

        @Override
        public DirListResponse buildPartial() {
            Preconditions.checkState((!this.names.isEmpty() ? 1 : 0) != 0);
            return this.createResponse(4000, new ArrayList<String>(), new ArrayList<FileStatus>());
        }

        @Override
        public DirListResponse buildFinal() {
            if (this.names.isEmpty()) {
                return new DirListStatResponse(this.request, 0, this.names, this.fileStatus);
            }
            return this.createResponse(0, null, null);
        }

        private DirListResponse createResponse(int statusCode, List<String> newNames, List<FileStatus> newFileStatuses) {
            Iterable<String> names = this.names;
            Iterable<FileStatus> fileStatus = this.fileStatus;
            this.names = newNames;
            this.fileStatus = newFileStatuses;
            if (this.isFirst) {
                names = Iterables.concat(Collections.singleton("."), names);
                fileStatus = Iterables.concat(Collections.singleton(new FileStatus(0L, 0L, 0, 0L)), fileStatus);
                this.isFirst = false;
            }
            return new DirListStatResponse(this.request, statusCode, names, fileStatus);
        }

        @Override
        public int count() {
            return this.names.size();
        }
    }

    private static class SimpleBuilder
    implements Builder {
        private final DirListRequest request;
        private List<String> names = new ArrayList<String>();

        public SimpleBuilder(DirListRequest request) {
            this.request = request;
        }

        @Override
        public void add(String name) {
            this.names.add(name);
        }

        @Override
        public void add(String name, FileStatus status) {
            this.names.add(name);
        }

        @Override
        public DirListResponse buildPartial() {
            Preconditions.checkState((!this.names.isEmpty() ? 1 : 0) != 0);
            DirListResponse response = new DirListResponse(this.request, 4000, this.names);
            this.names = new ArrayList<String>();
            return response;
        }

        @Override
        public DirListResponse buildFinal() {
            DirListResponse response = new DirListResponse(this.request, 0, this.names);
            this.names = null;
            return response;
        }

        @Override
        public int count() {
            return this.names.size();
        }
    }

    public static interface Builder {
        public void add(String var1);

        public void add(String var1, FileStatus var2);

        public DirListResponse buildPartial();

        public DirListResponse buildFinal();

        public int count();
    }
}

