/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.DirListResponse;
import org.dcache.xrootd.util.FileStatus;

public class DirListStatResponse
extends DirListResponse {
    private final Iterable<FileStatus> status;

    public DirListStatResponse(DirListRequest request, int statusCode, Iterable<String> names, Iterable<FileStatus> status) {
        super(request, statusCode, names);
        this.status = status;
    }

    public DirListStatResponse(DirListRequest request, Iterable<String> names, Iterable<FileStatus> status) {
        super(request, names);
        this.status = status;
    }

    public Iterable<FileStatus> getFileStatus() {
        return this.status;
    }

    @Override
    public int getDataLength() {
        if (!this.names.iterator().hasNext()) {
            return 0;
        }
        int length = 0;
        Iterator names = this.names.iterator();
        Iterator<FileStatus> status = this.status.iterator();
        while (names.hasNext() && status.hasNext()) {
            length += ((String)names.next()).length() + 1 + status.next().toString().length() + 1;
        }
        return length;
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        Iterator names = this.names.iterator();
        Iterator<FileStatus> status = this.status.iterator();
        if (names.hasNext() && status.hasNext()) {
            buffer.writeBytes(((String)names.next()).getBytes(StandardCharsets.US_ASCII));
            buffer.writeByte(10);
            buffer.writeBytes(status.next().toString().getBytes(StandardCharsets.US_ASCII));
            while (names.hasNext() && status.hasNext()) {
                buffer.writeByte(10);
                buffer.writeBytes(((String)names.next()).getBytes(StandardCharsets.US_ASCII));
                buffer.writeByte(10);
                buffer.writeBytes(status.next().toString().getBytes(StandardCharsets.US_ASCII));
            }
            if (this.stat == 4000) {
                buffer.writeByte(10);
            } else {
                buffer.writeByte(0);
            }
        }
    }
}

