/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.dcache.xrootd.protocol.messages.AbstractXrootdRequest;

public class FattrRequest
extends AbstractXrootdRequest {
    private final int fhandle;
    private final int subcode;
    private final int nattr;
    private final int options;
    private final String[] nvec;
    private String path;

    public FattrRequest(ByteBuf buffer) {
        super(buffer, 3020);
        this.fhandle = buffer.getInt(4);
        this.subcode = buffer.getUnsignedByte(8);
        int alen = buffer.getInt(20);
        ByteBuf bb = buffer.slice(24, alen);
        int pos = 0;
        int len = bb.bytesBefore(pos, alen, (byte)0);
        this.path = bb.toString(pos, len, StandardCharsets.US_ASCII);
        pos += len + 1;
        if (this.isList()) {
            this.nattr = 0;
            this.nvec = new String[0];
        } else {
            this.nattr = buffer.getUnsignedByte(9);
            this.nvec = new String[this.nattr];
            for (int i = 0; i < this.nattr; ++i) {
                len = bb.bytesBefore(pos += 2, alen - pos, (byte)0);
                this.nvec[i] = bb.toString(pos, len, StandardCharsets.US_ASCII);
                pos += len;
            }
        }
        Preconditions.checkState((this.nattr == this.nvec.length ? 1 : 0) != 0);
        this.options = buffer.getUnsignedByte(10);
    }

    public int getCode() {
        return this.subcode;
    }

    public int getFhandle() {
        return this.fhandle;
    }

    public boolean isNew() {
        return (this.options & 1) == 1;
    }

    public boolean aData() {
        return (this.options & 0x10) == 16;
    }

    public boolean isList() {
        return this.subcode == 2;
    }

    public boolean isGet() {
        return this.subcode == 1;
    }

    public boolean isSet() {
        return this.subcode == 3;
    }

    public boolean isDel() {
        return this.subcode == 0;
    }

    public String getPath() {
        return this.path;
    }

    public String[] getNames() {
        return this.nvec;
    }

    public int getNattr() {
        return this.nattr;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return String.format("fattr[%d,%d,%d,%d,%s]", this.subcode, this.fhandle, this.nattr, this.options, Arrays.toString(this.nvec));
    }
}

