/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.FattrRequest;

public class FattrResponse
extends AbstractXrootdResponse<FattrRequest>
implements ReferenceCounted {
    private final ByteBuf bb;

    public static Builder builder(FattrRequest request) {
        return new Builder(request);
    }

    public FattrResponse(FattrRequest request, List<NamedValue> attr) {
        block4: {
            block3: {
                super(request, 0);
                this.bb = Unpooled.buffer();
                if (!request.isList()) break block3;
                for (NamedValue nv2 : attr) {
                    this.bb.writeCharSequence((CharSequence)nv2.getName(), StandardCharsets.US_ASCII);
                    this.bb.writeByte(0);
                    if (!request.aData()) continue;
                    this.bb.writeInt(nv2.getValue().length);
                    this.bb.writeBytes(nv2.getValue());
                }
                break block4;
            }
            int nerrs = (int)attr.stream().filter(nv -> nv.getCode() != 0).count();
            this.bb.writeByte(nerrs);
            this.bb.writeByte(request.getNattr());
            for (NamedValue nv3 : attr) {
                this.bb.writeShort((int)nv3.getCode());
                this.bb.writeCharSequence((CharSequence)nv3.getName(), StandardCharsets.US_ASCII);
                this.bb.writeByte(0);
            }
            if (!request.isGet()) break block4;
            for (NamedValue nv3 : attr) {
                this.bb.writeInt(nv3.getValue().length);
                this.bb.writeBytes(nv3.getValue());
            }
        }
    }

    @Override
    public int getDataLength() {
        return this.bb.writerIndex();
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        buffer.writeBytes(this.bb);
    }

    public int refCnt() {
        return this.bb.refCnt();
    }

    public FattrResponse retain() {
        this.bb.retain();
        return this;
    }

    public FattrResponse retain(int increment) {
        this.bb.retain(increment);
        return this;
    }

    public FattrResponse touch() {
        this.bb.touch();
        return this;
    }

    public FattrResponse touch(Object hint) {
        this.bb.touch(hint);
        return this;
    }

    public boolean release() {
        return this.bb.release();
    }

    public boolean release(int decrement) {
        return this.bb.release(decrement);
    }

    public static class Builder {
        private final FattrRequest req;
        private final List<NamedValue> attr = new ArrayList<NamedValue>();

        private Builder(FattrRequest req) {
            this.req = req;
        }

        public Builder addName(String name) {
            return this.addName(name, 0);
        }

        public Builder addName(String name, int code) {
            return this.addNamedValue(name, code, new byte[0]);
        }

        public Builder addNamedValue(String name, int code, String value) {
            return this.addNamedValue(name, code, value == null ? new byte[]{} : value.getBytes(StandardCharsets.US_ASCII));
        }

        public Builder addNamedValue(String name, int code, byte[] value) {
            this.attr.add(new NamedValue(name, (short)code, value));
            return this;
        }

        public FattrResponse build() {
            return new FattrResponse(this.req, this.attr);
        }
    }

    public static class NamedValue {
        private final String name;
        private final short code;
        private final byte[] value;

        public NamedValue(String name, short code, byte[] value) {
            this.name = name;
            this.code = code;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getValue() {
            return this.value;
        }

        public short getCode() {
            return this.code;
        }
    }
}

