/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.protocol.messages.AbstractXrootdRequest;

public class PathRequest
extends AbstractXrootdRequest {
    private String path;
    private String opaque;

    public PathRequest(ByteBuf buffer, int requestId) {
        super(buffer, requestId);
        this.setPathAndOpaque(buffer, 24, buffer.getInt(20));
    }

    private void setPathAndOpaque(ByteBuf buffer, int begin, int length) {
        int end = begin + length;
        int pos = buffer.indexOf(begin, end, (byte)63);
        if (pos > -1) {
            this.setPath(buffer.toString(begin, pos - begin, StandardCharsets.US_ASCII));
            this.setOpaque(buffer.toString(pos + 1, end - (pos + 1), StandardCharsets.US_ASCII));
        } else {
            this.setPath(buffer.toString(begin, end - begin, StandardCharsets.US_ASCII));
            this.setOpaque("");
        }
    }

    public String getOpaque() {
        return this.opaque;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

