/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import org.dcache.xrootd.protocol.messages.GenericReadRequestMessage;

public class ReadRequest
extends GenericReadRequestMessage {
    private final int fhandle;
    private final long offset;
    private final int rlen;

    public ReadRequest(ByteBuf buffer) {
        super(buffer, 3013);
        this.fhandle = buffer.getInt(4);
        this.offset = buffer.getLong(8);
        this.rlen = buffer.getInt(16);
    }

    public int getFileHandle() {
        return this.fhandle;
    }

    public long getReadOffset() {
        return this.offset;
    }

    public int bytesToRead() {
        return this.rlen;
    }

    public int NumberOfPreReads() {
        return this.getSizeOfList();
    }

    public GenericReadRequestMessage.EmbeddedReadRequest[] getPreReadRequestList() {
        return this.getReadRequestList();
    }

    public String toString() {
        return String.format("read[handle=%d,offset=%d,length=%d]", this.fhandle, this.offset, this.rlen);
    }
}

