/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;

public class InboundAttnResponse
extends AbstractXrootdInboundResponse {
    private final int nextRequest;
    private final int actnum;
    private String message;
    private int wsec;
    private int msec;
    private int port;
    private String redirectData;
    private int rStreamId;
    private int rStat;
    private byte[] rData;

    public InboundAttnResponse(ByteBuf buffer, int requestId) {
        super(buffer);
        this.nextRequest = requestId;
        int plen = buffer.getInt(4);
        this.actnum = buffer.getInt(8);
        if (plen > 4) {
            this.parseParameters(buffer, plen - 4);
        }
    }

    public int getActnum() {
        return this.actnum;
    }

    public byte[] getrData() {
        return this.rData;
    }

    public String getMessage() {
        return this.message;
    }

    public int getMsec() {
        return this.msec;
    }

    public int getPort() {
        return this.port;
    }

    public String getRedirectData() {
        return this.redirectData;
    }

    @Override
    public int getRequestId() {
        return this.nextRequest;
    }

    public int getrStreamId() {
        return this.rStreamId;
    }

    public int getrStat() {
        return this.rStat;
    }

    public int getWsec() {
        return this.wsec;
    }

    private void parseParameters(ByteBuf buffer, int len) {
        switch (this.actnum) {
            case 5000: 
            case 5002: {
                this.message = buffer.toString(12, len, StandardCharsets.US_ASCII);
                break;
            }
            case 5001: {
                this.wsec = buffer.getInt(12);
                this.msec = buffer.getInt(16);
                break;
            }
            case 5003: {
                this.port = buffer.getInt(12);
                this.redirectData = buffer.toString(16, len - 4, StandardCharsets.US_ASCII);
                break;
            }
            case 5008: {
                this.rStreamId = buffer.getUnsignedShort(16);
                this.rStat = buffer.getUnsignedShort(18);
                int dlen = buffer.getInt(20);
                if (dlen <= 0) break;
                this.rData = new byte[dlen];
                buffer.getBytes(24, this.rData);
                break;
            }
            case 5004: {
                this.wsec = buffer.getInt(12);
                break;
            }
        }
    }
}

