/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;
import org.dcache.xrootd.util.ParseException;

public class InboundChecksumResponse
extends AbstractXrootdInboundResponse {
    private Map<String, String> checksums = new HashMap<String, String>();

    public InboundChecksumResponse(ByteBuf buffer) throws ParseException {
        super(buffer);
        int len = buffer.getInt(4);
        if (len > 0) {
            this.parse(buffer.toString(8, len, StandardCharsets.US_ASCII));
        }
    }

    public Map<String, String> getChecksums() {
        return this.checksums;
    }

    @Override
    public int getRequestId() {
        return 3001;
    }

    private void parse(String info) throws ParseException {
        String[] parts = info.split("\\s+");
        if (parts.length % 2 != 0) {
            throw new ParseException("malformed checksum info: '" + info + "'");
        }
        for (int i = 0; i < parts.length; i += 2) {
            this.checksums.put(parts[i], parts[i + 1]);
        }
    }
}

