/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.tpc.protocol.messages;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.function.Consumer;
import org.dcache.xrootd.core.XrootdEncoder;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdOutboundRequest;

public class OutboundAuthenticationRequest
extends AbstractXrootdOutboundRequest {
    private final String credType;
    private final int length;
    private final Consumer<ByteBuf> serializer;

    public OutboundAuthenticationRequest(int streamId, String credType, int length, Consumer<ByteBuf> serializer) {
        super(streamId, 3000);
        this.credType = credType;
        this.length = length;
        this.serializer = serializer;
    }

    @Override
    public void writeTo(ChannelHandlerContext ctx, ChannelPromise promise) {
        super.writeTo(ctx, promise);
    }

    @Override
    protected void getParams(ByteBuf buffer) {
        buffer.writeZero(12);
        XrootdEncoder.writeZeroPad(this.credType, buffer, 4);
        buffer.writeInt(this.length);
        this.serializer.accept(buffer);
    }

    @Override
    protected int getParamsLen() {
        return 20 + this.length;
    }
}

