/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.util;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.util.ReferenceCounted;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.slf4j.Logger;

public interface ByteBuffersProvider
extends ReferenceCounted {
    public static void logMetrics(String when, ByteBufAllocator allocator, Logger logger, String level) {
        if (allocator instanceof ByteBufAllocatorMetricProvider) {
            ByteBufAllocatorMetricProvider provider = (ByteBufAllocatorMetricProvider)allocator;
            switch (level.toUpperCase(Locale.ROOT)) {
                case "INFO": {
                    logger.info("allocator {}.{} \u2013\u2013 {}: {}", new Object[]{allocator.getClass().getSimpleName(), allocator.hashCode(), when, provider.metric()});
                    break;
                }
                case "DEBUG": {
                    logger.debug("allocator {}.{} \u2013\u2013 {}: {}", new Object[]{allocator.getClass().getSimpleName(), allocator.hashCode(), when, provider.metric()});
                    break;
                }
                case "TRACE": {
                    logger.trace("allocator {}.{} \u2013\u2013 {}: {}", new Object[]{allocator.getClass().getSimpleName(), allocator.hashCode(), when, provider.metric()});
                }
            }
        }
    }

    public ByteBuffer[] toByteBuffers();

    public long getWriteOffset();
}

