/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerProtocolFlags {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerProtocolFlags.class);
    private int flags = 0;
    private TlsMode mode;

    public ServerProtocolFlags() {
    }

    public ServerProtocolFlags(int flags) {
        this.flags = flags;
        this.mode = !this.requiresTLSForData() && !this.requiresTLSForGPF() && !this.requiresTLSForLogin() && !this.requiresTLSForSession() && !this.requiresTLSForTPC() ? TlsMode.OFF : TlsMode.STRICT;
    }

    public ServerProtocolFlags(ServerProtocolFlags serverProtocolFlags) {
        this.flags = serverProtocolFlags.flags;
        this.mode = serverProtocolFlags.mode;
    }

    public boolean allowsAnonymousGPFile() {
        boolean response = (this.flags & 0x800000) == 0x800000;
        LOGGER.trace("allowsAnonymousGPFile ? {}.", (Object)response);
        return response;
    }

    public int getFlags() {
        if (this.mode == TlsMode.OFF) {
            int shifted = this.flags << 8;
            LOGGER.trace("getFlags, mode is OFF, returning {}.", (Object)(shifted >>= 8));
            return shifted;
        }
        return this.flags;
    }

    public TlsMode getMode() {
        return this.mode;
    }

    public boolean goToTLS() {
        boolean response = this.mode != TlsMode.OFF && (this.flags & 0x40000000) == 0x40000000;
        LOGGER.trace("goToTLS ? {}.", (Object)response);
        return response;
    }

    public boolean hasManagerRole() {
        boolean response = (this.flags & 2) == 2;
        LOGGER.trace("hasManagerRole ? {}.", (Object)response);
        return response;
    }

    public boolean hasMetaServerRole() {
        boolean response = (this.flags & 0x100) == 256;
        LOGGER.trace("hasMetaServerRole ? {}.", (Object)response);
        return response;
    }

    public boolean hasProxyServerRole() {
        boolean response = (this.flags & 0x200) == 512;
        LOGGER.trace("hasProxyServerRole ? {}.", (Object)response);
        return response;
    }

    public boolean hasServerRole() {
        boolean response = (this.flags & 1) == 1;
        LOGGER.trace("hasServerRole ? {}.", (Object)response);
        return response;
    }

    public boolean hasSupervisorRole() {
        boolean response = (this.flags & 0x400) == 1024;
        LOGGER.trace("hasSupervisorRole ? {}.", (Object)response);
        return response;
    }

    public boolean isDataServer() {
        boolean response = (this.flags & 1) == 1;
        LOGGER.trace("isDataServer ? {}.", (Object)response);
        return response;
    }

    public boolean isLoadBalancingServer() {
        boolean response = (this.flags & 0) == 0;
        LOGGER.trace("isLoadBalancingServer ? {}.", (Object)response);
        return response;
    }

    public boolean requiresTLSForData() {
        boolean response = (this.flags & 0x1000000) == 0x1000000;
        LOGGER.trace("requiresTLSForData ? {}.", (Object)response);
        return response;
    }

    public boolean requiresTLSForGPF() {
        boolean response = (this.flags & 0x2000000) == 0x2000000;
        LOGGER.trace("requiresTLSForGPF ? {}.", (Object)response);
        return response;
    }

    public boolean requiresTLSForGPFA() {
        boolean response = (this.flags & 0x20000000) == 0x20000000;
        LOGGER.trace("requiresTLSForGPFA ? {}.", (Object)response);
        return response;
    }

    public boolean requiresTLSForLogin() {
        boolean response = (this.flags & 0x4000000) == 0x4000000;
        LOGGER.trace("requiresTLSForLogin ? {}.", (Object)response);
        return response;
    }

    public boolean requiresTLSForSession() {
        boolean response = (this.flags & 0x8000000) == 0x8000000;
        LOGGER.trace("requiresTLSForSession ? {}.", (Object)response);
        return response;
    }

    public boolean requiresTLSForTPC() {
        boolean response = (this.flags & 0x10000000) == 0x10000000;
        LOGGER.trace("requiresTLSForTPC ? {}.", (Object)response);
        return response;
    }

    public void setAllowsAnonymousGPFile(boolean value) {
        LOGGER.trace("setAllowsAnonymousGPFile {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x800000) : (this.flags &= 0xFF7FFFFF);
    }

    public void setDataServer(boolean value) {
        LOGGER.trace("setDataServer {}.", (Object)value);
        this.flags = value ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public void setMode(TlsMode mode) {
        LOGGER.trace("setMode {}.", (Object)mode);
        this.mode = mode;
    }

    public void setGoToTLS(boolean value) {
        LOGGER.trace("setGoToTLS {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x40000000) : (this.flags &= 0xBFFFFFFF);
    }

    public void setLoadBalancingServer(boolean value) {
        LOGGER.trace("setLoadBalancingServer {}.", (Object)value);
        this.flags = value ? (this.flags |= 0) : (this.flags &= 0xFFFFFFFF);
    }

    public void setManagerRole(boolean value) {
        LOGGER.trace("setManagerRole {}.", (Object)value);
        this.flags = value ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public void setMetaServerRole(boolean value) {
        LOGGER.trace("setMetaServerRole {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    public void setProxyServerRole(boolean value) {
        LOGGER.trace("setProxyServerRole {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x200) : (this.flags &= 0xFFFFFDFF);
    }

    public void setRequiresTLSForData(boolean value) {
        LOGGER.trace("setRequiresTLSForData {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x1000000) : (this.flags &= 0xFEFFFFFF);
    }

    public void setRequiresTLSForGPF(boolean value) {
        LOGGER.trace("setRequiresTLSForGPF {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x2000000) : (this.flags &= 0xFDFFFFFF);
    }

    public void setRequiresTLSForGPFA(boolean value) {
        LOGGER.trace("setRequiresTLSForGPFA {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x20000000) : (this.flags &= 0xDFFFFFFF);
    }

    public void setRequiresTLSForLogin(boolean value) {
        LOGGER.trace("setRequiresTLSForLogin {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x4000000) : (this.flags &= 0xFBFFFFFF);
    }

    public void setRequiresTLSForSession(boolean value) {
        LOGGER.trace("setRequiresTLSForSession {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x8000000) : (this.flags &= 0xF7FFFFFF);
    }

    public void setRequiresTLSForTPC(boolean value) {
        LOGGER.trace("setRequiresTLSForTPC {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x10000000) : (this.flags &= 0xEFFFFFFF);
    }

    public void setServerRole(boolean value) {
        LOGGER.trace("setServerRole {}.", (Object)value);
        this.flags = value ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public void setSupervisorRole(boolean value) {
        LOGGER.trace("setSupervisorRole {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
    }

    public void setSupportsGPFile(boolean value) {
        LOGGER.trace("setSupportsGPFile {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x200000) : (this.flags &= 0xFFDFFFFF);
    }

    public void setSupportsPGReadWrite(boolean value) {
        LOGGER.trace("setSupportsPGReadWrite {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x400000) : (this.flags &= 0xFFBFFFFF);
    }

    public void setSupportsPersistOnClose(boolean value) {
        LOGGER.trace("setSupportsPersistOnClose {}.", (Object)value);
        this.flags = value ? (this.flags |= 0x100000) : (this.flags &= 0xFFEFFFFF);
    }

    public void setSupportsTLS(boolean value) {
        LOGGER.trace("setSupportsTLS {}.", (Object)value);
        this.flags = value ? (this.flags |= Integer.MIN_VALUE) : (this.flags &= Integer.MAX_VALUE);
    }

    public boolean supportsGPFile() {
        boolean response = (this.flags & 0x200000) == 0x200000;
        LOGGER.trace("supportsGPFile ? {}.", (Object)response);
        return response;
    }

    public boolean supportsPGReadWrite() {
        boolean response = (this.flags & 0x400000) == 0x400000;
        LOGGER.trace("supportsPGReadWrite ? {}.", (Object)response);
        return response;
    }

    public boolean supportsPersistOnClose() {
        boolean response = (this.flags & 0x100000) == 0x100000;
        LOGGER.trace("supportsPersistOnClose ? {}.", (Object)response);
        return response;
    }

    public boolean supportsTLS() {
        boolean response = this.mode != TlsMode.OFF && (this.flags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        LOGGER.trace("supportsTLS ? {}.", (Object)response);
        return response;
    }

    public String toString() {
        return String.format("mode: %s, flags: %s (manager %s, meta-server %s, proxy-server %s, server %s, supervisor %s, data-server %s, load-balancer %s, tlsData %s, tlsGPF %s, tlsLogin %s, tlsSession %s, tlsTPC %s, goToTLS %s, anonGPF %s)", new Object[]{this.mode, this.getFlags(), this.hasManagerRole(), this.hasMetaServerRole(), this.hasProxyServerRole(), this.hasServerRole(), this.hasSupervisorRole(), this.isDataServer(), this.isLoadBalancingServer(), this.requiresTLSForData(), this.requiresTLSForGPF(), this.requiresTLSForLogin(), this.requiresTLSForSession(), this.requiresTLSForTPC(), this.goToTLS(), this.allowsAnonymousGPFile()});
    }

    public static enum TlsMode {
        OFF,
        OPTIONAL,
        STRICT;

    }
}

