/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserNameUtils {
    public static final String XROOTD_MAGIC_NAME = "_anon_";
    private static final String XROOTD_UNKNOWN_NAME = "????";
    private static final Pattern POSIX_COMPLIANT_UNAME = Pattern.compile("^[a-z_][a-z0-9_-]*[$]?$", 2);
    private static final Pattern UNAME_SLOT = Pattern.compile("[=]([^@=]+)[@]");

    public static String checkUsernameValid(String username) {
        if (XROOTD_UNKNOWN_NAME.equals(username)) {
            return XROOTD_MAGIC_NAME;
        }
        if (username == null || !username.isEmpty() && !POSIX_COMPLIANT_UNAME.matcher(username).matches()) {
            return XROOTD_MAGIC_NAME;
        }
        return username;
    }

    public static String checkAllUsernamesValid(String string) {
        StringBuilder builder = new StringBuilder();
        int from = 0;
        Matcher matcher = UNAME_SLOT.matcher(string);
        while (matcher.find()) {
            String group = matcher.group(1);
            int to = string.indexOf(group, from);
            builder.append(string.substring(from, to));
            String[] unamepid = group.split("[.]");
            if (unamepid.length == 1) {
                from = to + unamepid[0].length();
                builder.append(UserNameUtils.checkUsernameValid(unamepid[0]));
                continue;
            }
            for (int i = 0; i < unamepid.length - 1; ++i) {
                from = to + unamepid[i].length();
                builder.append(UserNameUtils.checkUsernameValid(unamepid[i])).append(".");
            }
            builder.append(unamepid[unamepid.length - 1]);
            from = from + unamepid[unamepid.length - 1].length() + 1;
        }
        if (from < string.length()) {
            builder.append(string.substring(from));
        }
        return builder.toString();
    }
}

