/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.actor.runner;

import java.io.OutputStream;
import org.canova.api.conf.Configuration;
import org.deeplearning4j.nn.conf.DeepLearningConfigurable;
import org.deeplearning4j.scaleout.actor.runner.DeepLearning4jDistributed;
import org.deeplearning4j.scaleout.job.JobIterator;
import org.deeplearning4j.scaleout.job.JobIteratorFactory;
import org.deeplearning4j.scaleout.statetracker.hazelcast.HazelCastStateTracker;
import org.deeplearning4j.scaleout.zookeeper.ZookeeperConfigurationRetriever;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepLearning4jDistributedApp
implements DeepLearningConfigurable {
    protected static final Logger log = LoggerFactory.getLogger(DeepLearning4jDistributedApp.class);
    @Option(name="-h", usage="the host to connect to as a master (default: 127.0.0.1)")
    protected String host = "localhost";
    @Option(name="-t", usage="type of worker")
    protected String type = "master";
    @Option(name="-ad", usage="address of master worker")
    protected String address;
    @Option(name="-stp", usage="state tracker port")
    protected int stateTrackerPort = -1;
    @Option(name="-jsonpath", usage="specify a path to a json file")
    protected String jsonPath;
    @Option(name="-json", usage="json for configuration")
    protected String json;
    protected DeepLearning4jDistributed runner;
    protected JobIterator iter;
    @Option(name="-jobclass", usage="job class")
    protected String jobFactoryClazz;

    public DeepLearning4jDistributedApp(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            parser.printUsage((OutputStream)System.err);
            log.error("Unable to parse args", (Throwable)e);
        }
    }

    public void exec() throws Exception {
        if (this.type != null && this.type.equals("worker")) {
            log.info("Initializing conf from zookeeper at " + this.host);
            ZookeeperConfigurationRetriever retriever = new ZookeeperConfigurationRetriever(this.host, 2181, "master");
            Configuration conf = retriever.retrieve();
            String address = conf.get("org.deeplearning4j.scaleout.masterurl");
            log.info("Creating hazel cast state tracker... " + conf.get("org.deeplearning4j.scaleout.statetracker.connectionstring"));
            HazelCastStateTracker stateTracker = new HazelCastStateTracker(conf.get("org.deeplearning4j.scaleout.statetracker.connectionstring"));
            log.info("Creating hazel cast via worker " + stateTracker.connectionString());
            this.runner = new DeepLearning4jDistributed(this.type, address);
            this.runner.setMasterHost(this.host);
            this.runner.setStateTracker(stateTracker);
            this.runner.setup(conf);
            retriever.close();
        } else {
            Configuration conf = new Configuration();
            JobIteratorFactory factory = (JobIteratorFactory)Class.forName(this.jobFactoryClazz).newInstance();
            this.iter = factory.create();
            this.runner = new DeepLearning4jDistributed("master", this.iter);
            this.runner.setStateTrackerPort(this.stateTrackerPort);
            this.runner.setup(conf);
        }
    }

    public void train() {
        this.runner.train();
    }

    public void shutdown() {
    }

    public boolean isDone() {
        return this.iter.hasNext();
    }

    public static void main(String[] args) throws Exception {
        DeepLearning4jDistributedApp app = new DeepLearning4jDistributedApp(args);
        app.exec();
        if (app.type.equals("master")) {
            app.train();
        }
    }

    public void setup(Configuration conf) {
    }
}

