/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.authorities;

import java.util.NoSuchElementException;
import org.dmfs.optional.Absent;
import org.dmfs.optional.Optional;
import org.dmfs.optional.Present;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.utils.Parsed;
import org.dmfs.rfc3986.validation.CharSets;

public final class OptionalLazyUserInfo
implements Optional<UriEncoded>,
Parsed {
    private final UriEncoded mEncodedAuthority;
    private Optional<UriEncoded> mUserInfo;
    private int mEnd;

    public OptionalLazyUserInfo(UriEncoded encodedAuthority) {
        this.mEncodedAuthority = encodedAuthority;
    }

    public boolean isPresent() {
        return this.userInfo().isPresent();
    }

    public UriEncoded value(UriEncoded defaultValue) {
        return (UriEncoded)this.userInfo().value((Object)defaultValue);
    }

    public UriEncoded value() throws NoSuchElementException {
        return (UriEncoded)this.userInfo().value();
    }

    private Optional<UriEncoded> userInfo() {
        if (this.mUserInfo == null) {
            this.mUserInfo = this.parsedUserInfo();
        }
        return this.mUserInfo;
    }

    private Optional<UriEncoded> parsedUserInfo() {
        int i;
        UriEncoded encodedAuthority = this.mEncodedAuthority;
        int count = encodedAuthority.length();
        for (i = 0; i < count && (CharSets.REG_NAME_CHAR.contains(encodedAuthority.charAt(i)) || encodedAuthority.charAt(i) == ':'); ++i) {
        }
        if (i == count || encodedAuthority.charAt(i) != '@') {
            return Absent.absent();
        }
        this.mEnd = i + 1;
        return new Present((Object)encodedAuthority.subSequence(0, i));
    }

    @Override
    public int parsedLength() {
        return this.mEnd;
    }
}

