/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.paths;

import java.util.Iterator;
import org.dmfs.rfc3986.Path;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.paths.EmptyPath;
import org.dmfs.rfc3986.paths.EncodedPath;
import org.dmfs.rfc3986.utils.Parsed;
import org.dmfs.rfc3986.validation.CharSets;

public final class LazyPath
implements Path,
Parsed {
    private final UriEncoded mUriEncoded;
    private Path mDelegate;
    private int mEnd;

    public LazyPath(UriEncoded uri) {
        this.mUriEncoded = uri;
    }

    @Override
    public boolean isEmpty() {
        return this.path().isEmpty();
    }

    @Override
    public boolean isAbsolute() {
        return this.path().isAbsolute();
    }

    @Override
    public Iterator<UriEncoded> iterator() {
        return this.path().iterator();
    }

    private Path path() {
        if (this.mDelegate == null) {
            this.mDelegate = this.parsedPath();
        }
        return this.mDelegate;
    }

    private Path parsedPath() {
        int i = 0;
        UriEncoded uriEncoded = this.mUriEncoded;
        int count = uriEncoded.length();
        if (i == count) {
            return EmptyPath.INSTANCE;
        }
        while (i < count && (CharSets.PCHAR.contains(uriEncoded.charAt(i)) || uriEncoded.charAt(i) == '/')) {
            ++i;
        }
        this.mEnd = i;
        return new EncodedPath(uriEncoded.subSequence(0, i));
    }

    @Override
    public int parsedLength() {
        this.path();
        return this.mEnd;
    }
}

