/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.schemes;

import java.util.NoSuchElementException;
import org.dmfs.optional.Absent;
import org.dmfs.optional.Optional;
import org.dmfs.optional.Present;
import org.dmfs.rfc3986.Scheme;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.utils.Parsed;
import org.dmfs.rfc3986.validation.CharSets;

public final class OptionalLazyScheme
implements Optional<Scheme>,
Parsed {
    private final UriEncoded mUriEncoded;
    private Optional<Scheme> mOptionalScheme;
    private int mEnd;

    public OptionalLazyScheme(UriEncoded uriEncoded) {
        this.mUriEncoded = uriEncoded;
    }

    public boolean isPresent() {
        return this.scheme().isPresent();
    }

    public Scheme value(Scheme defaultValue) {
        return (Scheme)this.scheme().value((Object)defaultValue);
    }

    public Scheme value() throws NoSuchElementException {
        return (Scheme)this.scheme().value();
    }

    private Optional<Scheme> scheme() {
        if (this.mOptionalScheme == null) {
            this.mOptionalScheme = this.parsedScheme();
        }
        return this.mOptionalScheme;
    }

    private Optional<Scheme> parsedScheme() {
        int i;
        UriEncoded uriEncoded = this.mUriEncoded;
        int count = uriEncoded.length();
        if (count < 2 || !CharSets.ALPHA.contains(uriEncoded.charAt(0))) {
            return Absent.absent();
        }
        for (i = 1; i < count && CharSets.SCHEME_CHAR.contains(uriEncoded.charAt(i)); ++i) {
        }
        if (i < 2 || i == count || uriEncoded.charAt(i) != ':') {
            return Absent.absent();
        }
        this.mEnd = i + 1;
        return new Present((Object)new ParsedScheme(uriEncoded.subSequence(0, i)));
    }

    @Override
    public int parsedLength() {
        this.scheme();
        return this.mEnd;
    }

    private static final class ParsedScheme
    implements Scheme {
        private final CharSequence mScheme;

        private ParsedScheme(CharSequence scheme) {
            this.mScheme = scheme;
        }

        @Override
        public int length() {
            return this.mScheme.length();
        }

        @Override
        public char charAt(int i) {
            return this.mScheme.charAt(i);
        }

        @Override
        public CharSequence subSequence(int i, int i1) {
            return this.mScheme.subSequence(i, i1);
        }

        @Override
        public String toString() {
            return this.mScheme.toString();
        }
    }
}

