/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.util.index;

import org.drools.base.base.ValueType;
import org.drools.base.rule.IndexableConstraint;
import org.drools.base.rule.accessor.TupleValueExtractor;
import org.drools.base.rule.constraint.BetaConstraint;
import org.drools.base.util.index.ConstraintTypeOperator;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.BetaRangeIndexOption;
import org.kie.internal.conf.IndexPrecedenceOption;

public class IndexUtil {
    static boolean USE_COMPARISON_INDEX = true;
    static boolean USE_COMPARISON_INDEX_JOIN = true;

    public static boolean compositeAllowed(BetaConstraint[] constraints, int betaNodeType, KieBaseConfiguration config) {
        int firstUnification = -1;
        int firstNonUnification = -1;
        int length = constraints.length;
        for (int i = 0; i < length; ++i) {
            if (IndexUtil.isIndexable(constraints[i], betaNodeType, config)) {
                boolean isUnification = ((IndexableConstraint)((Object)constraints[i])).isUnification();
                if (isUnification && firstUnification == -1) {
                    firstUnification = i;
                } else if (!isUnification && firstNonUnification == -1) {
                    firstNonUnification = i;
                }
            }
            if (firstUnification != -1 && firstNonUnification != -1) break;
        }
        if (firstNonUnification > 0) {
            IndexUtil.swap(constraints, 0, firstNonUnification);
        }
        return firstUnification == -1;
    }

    public static boolean isIndexable(BetaConstraint constraint, int nodeType, KieBaseConfiguration config) {
        return constraint instanceof IndexableConstraint && ((IndexableConstraint)((Object)constraint)).isIndexable(nodeType, config) && !IndexUtil.isBigDecimalEqualityConstraint((IndexableConstraint)((Object)constraint));
    }

    public static boolean canHaveRangeIndex(int nodeType, IndexableConstraint constraint, KieBaseConfiguration config) {
        return IndexUtil.canHaveRangeIndexForNodeType(nodeType, config) && IndexUtil.areRangeIndexCompatibleOperands(constraint);
    }

    private static boolean canHaveRangeIndexForNodeType(int nodeType, KieBaseConfiguration config) {
        if (USE_COMPARISON_INDEX_JOIN && ((BetaRangeIndexOption)config.getOption(BetaRangeIndexOption.KEY)).isBetaRangeIndexEnabled()) {
            boolean b = USE_COMPARISON_INDEX && (nodeType == 11142708 || nodeType == 11470388 || nodeType == 10815028);
            return USE_COMPARISON_INDEX && (nodeType == 11142708 || nodeType == 11470388 || nodeType == 10815028);
        }
        return USE_COMPARISON_INDEX && (nodeType == 11142708 || nodeType == 11470388);
    }

    private static boolean areRangeIndexCompatibleOperands(IndexableConstraint constraint) {
        TupleValueExtractor leftTupleExtractor;
        TupleValueExtractor rightTupleExtractor;
        try {
            rightTupleExtractor = constraint.getRightIndexExtractor();
            leftTupleExtractor = constraint.getLeftIndexExtractor();
        }
        catch (UnsupportedOperationException uoe) {
            return false;
        }
        if (rightTupleExtractor == null || leftTupleExtractor == null) {
            return false;
        }
        ValueType leftValueType = rightTupleExtractor.getValueType();
        ValueType rightValueType = leftTupleExtractor.getValueType();
        if (leftValueType != null && rightValueType != null) {
            if (leftValueType.isNumber() && rightValueType.isNumber()) {
                return true;
            }
            Class<?> leftClass = leftValueType.getClassType();
            Class<?> rightClass = rightValueType.getClassType();
            return leftClass != null && rightClass != null && Comparable.class.isAssignableFrom(leftClass) && leftClass.equals(rightClass);
        }
        return false;
    }

    public static boolean isIndexableForNode(int nodeType, BetaConstraint constraint, KieBaseConfiguration config) {
        if (!(constraint instanceof IndexableConstraint)) {
            return false;
        }
        ConstraintTypeOperator constraintType = ((IndexableConstraint)((Object)constraint)).getConstraintType();
        if (IndexUtil.isBigDecimalEqualityConstraint((IndexableConstraint)((Object)constraint))) {
            return false;
        }
        return constraintType.isIndexableForNode(nodeType, (IndexableConstraint)((Object)constraint), config);
    }

    public static boolean isBigDecimalEqualityConstraint(IndexableConstraint indexableConstraint) {
        if (indexableConstraint.getConstraintType() == ConstraintTypeOperator.EQUAL) {
            if (indexableConstraint.getFieldExtractor() != null) {
                return indexableConstraint.getFieldExtractor() != null && indexableConstraint.getFieldExtractor().getValueType() == ValueType.BIG_DECIMAL_TYPE;
            }
            return IndexUtil.isBigDecimalEqualityConstraint(indexableConstraint.getLeftIndexExtractor()) || IndexUtil.isBigDecimalEqualityConstraint(indexableConstraint.getRightIndexExtractor());
        }
        return false;
    }

    private static boolean isBigDecimalEqualityConstraint(TupleValueExtractor tupleValueExtractor) {
        return tupleValueExtractor != null && tupleValueExtractor.getValueType() == ValueType.BIG_DECIMAL_TYPE;
    }

    public static boolean[] isIndexableForNode(IndexPrecedenceOption indexPrecedenceOption, int nodeType, int keyDepth, BetaConstraint[] constraints, KieBaseConfiguration config) {
        if (keyDepth < 1) {
            return new boolean[constraints.length];
        }
        return indexPrecedenceOption == IndexPrecedenceOption.EQUALITY_PRIORITY ? IndexUtil.findIndexableWithEqualityPriority(nodeType, keyDepth, constraints, config) : IndexUtil.findIndexableWithPatternOrder(nodeType, keyDepth, constraints, config);
    }

    private static boolean[] findIndexableWithEqualityPriority(int nodeType, int keyDepth, BetaConstraint[] constraints, KieBaseConfiguration config) {
        boolean[] indexable = new boolean[constraints.length];
        if (IndexUtil.hasEqualIndexable(keyDepth, indexable, constraints)) {
            return indexable;
        }
        if (!IndexUtil.canHaveRangeIndexForNodeType(nodeType, config)) {
            return indexable;
        }
        for (int i = 0; i < constraints.length; ++i) {
            if (!IndexUtil.isIndexable(constraints[i], nodeType, config)) continue;
            IndexUtil.sortRangeIndexable(constraints, indexable, i);
            break;
        }
        return indexable;
    }

    private static boolean[] findIndexableWithPatternOrder(int nodeType, int keyDepth, BetaConstraint[] constraints, KieBaseConfiguration config) {
        boolean[] indexable = new boolean[constraints.length];
        for (int i = 0; i < constraints.length; ++i) {
            if (!IndexUtil.isIndexable(constraints[i], nodeType, config)) continue;
            if (IndexUtil.isEqualIndexable(constraints[i])) {
                IndexUtil.sortEqualIndexable(keyDepth, indexable, constraints, i);
                break;
            }
            IndexUtil.sortRangeIndexable(constraints, indexable, i);
            break;
        }
        return indexable;
    }

    private static boolean hasEqualIndexable(int keyDepth, boolean[] indexable, BetaConstraint[] constraints) {
        return IndexUtil.sortEqualIndexable(keyDepth, indexable, constraints, 0);
    }

    private static boolean sortEqualIndexable(int keyDepth, boolean[] indexable, BetaConstraint[] constraints, int start) {
        boolean hasEqualIndexable = false;
        int indexableCouter = 0;
        for (int i = start; i < constraints.length; ++i) {
            if (!IndexUtil.isEqualIndexable(constraints[i])) continue;
            hasEqualIndexable = true;
            if (keyDepth <= indexableCouter) continue;
            IndexUtil.swap(constraints, i, indexableCouter);
            indexable[indexableCouter++] = true;
        }
        return hasEqualIndexable;
    }

    private static void sortRangeIndexable(BetaConstraint[] constraints, boolean[] indexable, int i) {
        IndexUtil.swap(constraints, i, 0);
        indexable[0] = true;
    }

    public static boolean isEqualIndexable(BetaConstraint constraint) {
        return constraint instanceof IndexableConstraint && ((IndexableConstraint)((Object)constraint)).getConstraintType() == ConstraintTypeOperator.EQUAL && !IndexUtil.isBigDecimalEqualityConstraint((IndexableConstraint)((Object)constraint));
    }

    private static void swap(BetaConstraint[] constraints, int p1, int p2) {
        if (p1 != p2) {
            BetaConstraint temp = constraints[p2];
            constraints[p2] = constraints[p1];
            constraints[p1] = temp;
        }
    }
}

